/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.kohsuke.args4j.spi;

import com.android.jack.kohsuke.args4j.CmdLineException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.OptionDef;
import com.android.jack.kohsuke.args4j.spi.Messages;
import com.android.jack.kohsuke.args4j.spi.OptionHandler;
import com.android.jack.kohsuke.args4j.spi.Parameters;
import com.android.jack.kohsuke.args4j.spi.Setter;
import com.android.jack.kohsuke.args4j.spi.SubCommand;
import com.android.jack.kohsuke.args4j.spi.SubCommands;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ResourceBundle;

public class SubCommandHandler
extends OptionHandler<Object> {
    private final SubCommands commands;

    public SubCommandHandler(CmdLineParser parser, OptionDef option, Setter<Object> setter) {
        super(parser, option, setter);
        this.commands = setter.asAnnotatedElement().getAnnotation(SubCommands.class);
        if (this.commands == null) {
            throw new IllegalStateException("SubCommandHandler must be used with @SubCommands annotation");
        }
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        String subCmd = params.getParameter(0);
        for (SubCommand c : this.commands.value()) {
            if (!c.name().equals(subCmd)) continue;
            this.setter.addValue(this.subCommand(c, params));
            return params.size();
        }
        return this.fallback(subCmd);
    }

    protected int fallback(String subCmd) throws CmdLineException {
        throw new CmdLineException(this.owner, Messages.ILLEGAL_OPERAND, this.option.toString(), subCmd);
    }

    protected Object subCommand(SubCommand c, final Parameters params) throws CmdLineException {
        Object subCmd = this.instantiate(c);
        CmdLineParser p = this.configureParser(subCmd, c);
        p.parseArgument((Collection<String>)new AbstractList<String>(){

            @Override
            public String get(int index) {
                try {
                    return params.getParameter(index + 1);
                }
                catch (CmdLineException e) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public int size() {
                return params.size() - 1;
            }
        });
        return subCmd;
    }

    protected CmdLineParser configureParser(Object subCmd, SubCommand c) {
        return new CmdLineParser(subCmd);
    }

    protected Object instantiate(SubCommand c) {
        try {
            return c.impl().newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to instantiate " + c, e);
        }
    }

    @Override
    public String getDefaultMetaVariable() {
        StringBuffer rv = new StringBuffer();
        rv.append("[");
        for (SubCommand sc : this.commands.value()) {
            rv.append(sc.name()).append(" | ");
        }
        rv.delete(rv.length() - 3, rv.length());
        rv.append("]");
        return rv.toString();
    }

    @Override
    public String getMetaVariable(ResourceBundle rb) {
        return this.getDefaultMetaVariable();
    }
}

