/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JTryStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NBlock;
import com.android.jack.jayce.v0004.nodes.NCatchBlock;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NTryStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.TRY_STATEMENT;
    @Nonnull
    public List<NStatement> resourcesDeclaration = Collections.emptyList();
    @CheckForNull
    public NBlock tryBlock;
    @Nonnull
    public List<NCatchBlock> catchBlocks = Collections.emptyList();
    @CheckForNull
    public NBlock finallyBlock;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JTryStatement jTryStatement = (JTryStatement)node;
        this.resourcesDeclaration = loader.load(NStatement.class, jTryStatement.getResourcesDeclarations());
        this.tryBlock = (NBlock)loader.load(jTryStatement.getTryBlock());
        this.catchBlocks = loader.load(NCatchBlock.class, jTryStatement.getCatchBlocks());
        this.finallyBlock = (NBlock)loader.load(jTryStatement.getFinallyBlock());
        this.sourceInfo = jTryStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JTryStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.tryBlock != null);
        assert (this.sourceInfo != null);
        ArrayList<JCatchBlock> jCatchBlocks = new ArrayList<JCatchBlock>(this.catchBlocks.size());
        for (NCatchBlock catchBlock : this.catchBlocks) {
            jCatchBlocks.add(catchBlock.exportAsJast(exportSession));
        }
        JBlock jFinallyBlock = this.finallyBlock != null ? this.finallyBlock.exportAsJast(exportSession) : null;
        ArrayList<JStatement> jResourcesDeclaration = new ArrayList<JStatement>(this.resourcesDeclaration.size());
        for (NStatement stmt : this.resourcesDeclaration) {
            jResourcesDeclaration.add(stmt.exportAsJast(exportSession));
        }
        JTryStatement jTryStatement = new JTryStatement(this.sourceInfo, jResourcesDeclaration, this.tryBlock.exportAsJast(exportSession), jCatchBlocks, jFinallyBlock);
        return jTryStatement;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNodes(this.resourcesDeclaration);
        out.writeNode(this.tryBlock);
        out.writeNodes(this.catchBlocks);
        out.writeNode(this.finallyBlock);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.resourcesDeclaration = in.readNodes(NStatement.class);
        this.tryBlock = in.readNode(NBlock.class);
        this.catchBlocks = in.readNodes(NCatchBlock.class);
        this.finallyBlock = in.readNode(NBlock.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return Collections.emptyList();
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
    }
}

