/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CaseStatementLinker;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NBlock;
import com.android.jack.jayce.v0004.nodes.NExpression;
import com.android.jack.jayce.v0004.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NSwitchStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.SWITCH_STATEMENT;
    @CheckForNull
    public NExpression expr;
    @Nonnull
    public List<String> cases = Collections.emptyList();
    @CheckForNull
    public NBlock body;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JSwitchStatement switchStatement = (JSwitchStatement)node;
        this.expr = (NExpression)loader.load(switchStatement.getExpr());
        List<JCaseStatement> fullCaseList = switchStatement.getCases();
        if (switchStatement.getDefaultCase() != null) {
            fullCaseList = new ArrayList<JCaseStatement>(fullCaseList);
            fullCaseList.add(switchStatement.getDefaultCase());
        }
        this.cases = loader.getIds(loader.getCaseSymbols(), fullCaseList);
        this.body = (NBlock)loader.load(switchStatement.getBody());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), switchStatement.getJCatchBlocks());
        this.sourceInfo = switchStatement.getSourceInfo();
    }

    @Override
    @Nonnull
    public JSwitchStatement exportAsJast(@Nonnull ExportSession exportSession) throws JMethodLookupException, JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.expr != null);
        assert (this.body != null);
        JSwitchStatement jSwitch = new JSwitchStatement(this.sourceInfo, this.expr.exportAsJast(exportSession), this.body.exportAsJast(exportSession), new ArrayList<JCaseStatement>(1), null);
        for (String caseId : this.cases) {
            exportSession.getCaseResolver().addLink(caseId, new CaseStatementLinker(jSwitch));
        }
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jSwitch));
        }
        return jSwitch;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNode(this.expr);
        out.writeIds(this.cases);
        out.writeNode(this.body);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.expr = in.readNode(NExpression.class);
        this.cases = in.readIds();
        this.body = in.readNode(NBlock.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

