/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NLiteral;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class NArrayLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.ARRAY_LITERAL;
    @Nonnull
    public List<NLiteral> values = Collections.emptyList();

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JArrayLiteral jArrayLiteral = (JArrayLiteral)node;
        this.values = loader.load(NLiteral.class, jArrayLiteral.getValues());
        this.sourceInfo = jArrayLiteral.getSourceInfo();
    }

    @Override
    @Nonnull
    public JArrayLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        ArrayList<JLiteral> jValues = new ArrayList<JLiteral>(this.values.size());
        for (NLiteral value : this.values) {
            jValues.add(value.exportAsJast(exportSession));
        }
        JArrayLiteral jArrayLiteral = new JArrayLiteral(this.sourceInfo, jValues);
        return jArrayLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeNodes(this.values);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.values = in.readNodes(NLiteral.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

