/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.nodes;

import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.JayceMethodLoader;
import com.android.jack.jayce.v0004.io.ExportSession;
import com.android.jack.jayce.v0004.io.ImportHelper;
import com.android.jack.jayce.v0004.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0004.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0004.io.Token;
import com.android.jack.jayce.v0004.nodes.NAnnotation;
import com.android.jack.jayce.v0004.nodes.NLiteral;
import com.android.jack.jayce.v0004.nodes.NMarker;
import com.android.jack.jayce.v0004.nodes.NMethod;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAnnotationMethod
extends NMethod {
    @Nonnull
    public static final Token TOKEN = Token.ANNOTATION_METHOD;
    @CheckForNull
    public NLiteral defaultValue;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAnnotationMethod jAnnotationMethod = (JAnnotationMethod)node;
        assert (jAnnotationMethod.getBody() == null);
        assert (jAnnotationMethod.getParams().isEmpty());
        this.name = jAnnotationMethod.getName();
        this.returnType = ImportHelper.getSignatureName(jAnnotationMethod.getType());
        this.modifier = jAnnotationMethod.getModifier();
        this.annotations = loader.load(NAnnotation.class, jAnnotationMethod.getAnnotations());
        this.defaultValue = (NLiteral)loader.load(jAnnotationMethod.getDefaultValue());
        this.markers = loader.load(NMarker.class, jAnnotationMethod.getAllMarkers());
        this.sourceInfo = jAnnotationMethod.getSourceInfo();
    }

    @Override
    @Nonnull
    public JAnnotationMethod exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public JMethod exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceClassOrInterfaceLoader enclosingLoader) throws JTypeLookupException, JMethodLookupException {
        assert (this.name != null);
        assert (this.returnType != null);
        assert (this.sourceInfo != null);
        assert (this.body == null);
        assert (this.methodNodeIndex != -1);
        SourceInfo info = this.sourceInfo;
        JDefinedClassOrInterface enclosingType = exportSession.getCurrentType();
        assert (enclosingType != null);
        JType returnJType = exportSession.getLookup().getType(this.returnType);
        JAnnotationMethod jAnnotationMethod = new JAnnotationMethod(info, new JMethodId(new JMethodIdWide(this.name, MethodKind.INSTANCE_VIRTUAL), returnJType), enclosingType, this.modifier, new JayceMethodLoader(this, this.methodNodeIndex, enclosingLoader));
        exportSession.setCurrentMethod(jAnnotationMethod);
        if (this.defaultValue != null) {
            jAnnotationMethod.setDefaultValue(this.defaultValue.exportAsJast(exportSession));
        }
        for (NMarker marker : this.markers) {
            jAnnotationMethod.addMarker(marker.exportAsJast(exportSession));
        }
        return jAnnotationMethod;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.annotations != null);
        out.writeId(this.name);
        out.writeId(this.returnType);
        out.writeInt(this.modifier);
        out.writeNodes(this.annotations);
        out.writeNode(this.defaultValue);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.name = in.readId();
        this.returnType = in.readId();
        this.modifier = in.readInt();
        this.annotations = in.readNodes(NAnnotation.class);
        this.defaultValue = in.readNode(NLiteral.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }
}

