/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0004.io;

import com.android.jack.util.StringUtils;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

class JayceOutputStream
implements DataOutput {
    @Nonnull
    private final DataOutputStream out;

    public JayceOutputStream(@Nonnull OutputStream out) {
        this.out = new DataOutputStream(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.out.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        int end;
        int remaining = v >> 7;
        boolean hasMore = true;
        int n = end = (v & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (v >> 6 & 1);
            this.writeByte((byte)(v & 0x7F | (hasMore ? 128 : 0)));
            v = remaining;
            remaining >>= 7;
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        long end;
        long remaining = v >> 7;
        boolean hasMore = true;
        long l = end = (v & Long.MIN_VALUE) == 0L ? 0L : -1L;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1L) != (v >> 6 & 1L);
            this.writeByte((byte)(v & 0x7FL | (long)(hasMore ? 128 : 0)));
            v = remaining;
            remaining >>= 7;
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            byte[] utf8String = StringUtils.stringToUtf8Bytes(s);
            this.writeInt(utf8String.length);
            this.write(utf8String);
        }
    }

    public void writeBuffer(byte[] b) throws IOException {
        if (b == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(b.length);
            this.write(b);
        }
    }

    public void close() throws IOException {
        this.out.close();
    }
}

