/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLiteral;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JLookup;
import com.android.jack.lookup.JPhantomLookup;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NEnumLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.ENUM_LITERAL;
    @CheckForNull
    public String enumFieldDeclaringType;
    @CheckForNull
    public String enumFieldName;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JEnumLiteral jEnumLiteral = (JEnumLiteral)node;
        this.enumFieldDeclaringType = ImportHelper.getSignatureName(jEnumLiteral.getType());
        this.enumFieldName = jEnumLiteral.getFieldId().getName();
        this.sourceInfo = loader.load(jEnumLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JEnumLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.enumFieldDeclaringType != null);
        assert (this.enumFieldName != null);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JPhantomLookup lookup = exportSession.getLookup();
        JEnum enumType = ((JLookup)lookup).getEnum(this.enumFieldDeclaringType);
        JFieldId field = exportSession.getFieldId(enumType, this.enumFieldName, enumType, FieldKind.STATIC);
        JEnumLiteral jEnumLiteral = new JEnumLiteral(jSourceInfo, field);
        return jEnumLiteral;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.enumFieldDeclaringType);
        out.writeId(this.enumFieldName);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.enumFieldDeclaringType = in.readId();
        this.enumFieldName = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

