/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.jayce.v0002.nodes.NVariable;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NLocal
extends NVariable {
    @Nonnull
    public static final Token TOKEN = Token.LOCAL;
    @CheckForNull
    public String id;
    public int modifiers;
    @CheckForNull
    public String type;
    @CheckForNull
    public String name;
    @Nonnull
    public List<NAnnotation> annotationSet = Collections.emptyList();
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JLocal jLocal = (JLocal)node;
        this.id = loader.getLocalSymbols().getId(jLocal);
        this.modifiers = jLocal.getModifier();
        this.type = ImportHelper.getSignatureName(jLocal.getType());
        this.name = jLocal.getName();
        this.annotationSet = loader.load(NAnnotation.class, jLocal.getAnnotations());
        this.markers = loader.load(NMarker.class, jLocal.getAllMarkers());
        this.sourceInfo = loader.load(jLocal.getSourceInfo());
    }

    @Override
    @Nonnull
    public JLocal exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.type != null);
        assert (this.id != null);
        JLocal jLocal = new JLocal(this.sourceInfo.exportAsJast(exportSession), this.name, exportSession.getLookup().getType(this.type), this.modifiers, null);
        NLocal.manageSynthetic(jLocal);
        exportSession.getLocalResolver().addTarget(this.id, jLocal);
        for (NAnnotation annotation : this.annotationSet) {
            jLocal.addAnnotation(annotation.exportAsJast(exportSession));
        }
        for (NMarker marker : this.markers) {
            jLocal.addMarker(marker.exportAsJast(exportSession));
        }
        return jLocal;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.id);
        out.writeInt(this.modifiers);
        out.writeId(this.type);
        out.writeId(this.name);
        out.writeNodes(this.annotationSet);
        out.writeNodes(this.markers);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.id = in.readId();
        this.modifiers = in.readInt();
        this.type = in.readId();
        this.name = in.readId();
        this.annotationSet = in.readNodes(NAnnotation.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

