/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NLiteral;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NClassLiteral
extends NLiteral {
    @Nonnull
    public static final Token TOKEN = Token.CLASS_LITERAL;
    @Nonnull
    private static final String JAVA_LANG_CLASS = "Ljava/lang/Class;";
    @CheckForNull
    public String refType;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JClassLiteral jClassLiteral = (JClassLiteral)node;
        this.refType = ImportHelper.getSignatureName(jClassLiteral.getRefType());
        this.sourceInfo = loader.load(jClassLiteral.getSourceInfo());
    }

    @Override
    @Nonnull
    public JClassLiteral exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.refType != null);
        return new JClassLiteral(this.sourceInfo.exportAsJast(exportSession), exportSession.getLookup().getType(this.refType), exportSession.getLookup().getClass(JAVA_LANG_CLASS));
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        out.writeId(this.refType);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.refType = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

