/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.io;

import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.linker.SymbolManager;
import com.android.jack.jayce.v0002.NNode;
import com.android.jack.jayce.v0002.NodeFactory;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.sched.marker.Marker;
import com.android.sched.marker.SerializableMarker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ImportHelper {
    @Nonnull
    private final NodeFactory factory;
    @Nonnull
    private final SymbolManager<JCatchBlock> catchBlockSymbols = new SymbolManager();
    @Nonnull
    private final SymbolManager<JCaseStatement> caseSymbols = new SymbolManager();
    @Nonnull
    private final SymbolManager<JField> fieldSymbols = new SymbolManager();
    @Nonnull
    private final SymbolManager<JLocal> localSymbols = new SymbolManager();
    @Nonnull
    private final SymbolManager<JParameter> parameterSymbols = new SymbolManager();
    @Nonnull
    private final SymbolManager<JLabeledStatement> labelSymbols = new SymbolManager();

    public ImportHelper(@Nonnull NodeFactory factory) {
        this.factory = factory;
    }

    @CheckForNull
    public static String getMethodSignature(@CheckForNull JMethod method) {
        return method != null ? NNode.getFormatter().getName(method) : null;
    }

    @CheckForNull
    public static String getSignatureName(@CheckForNull JType type) {
        return type != null ? NNode.getFormatter().getName(type) : null;
    }

    @Nonnull
    public static List<String> getSignatureNameList(@Nonnull List<? extends JType> types) {
        int typesNumber = types.size();
        ArrayList<String> signatures = new ArrayList<String>(typesNumber);
        for (JType jType : types) {
            signatures.add(NNode.getFormatter().getName(jType));
        }
        return signatures;
    }

    @CheckForNull
    public static String getLabelName(@CheckForNull JLabel label) {
        if (label != null) {
            return label.getName();
        }
        return null;
    }

    @CheckForNull
    public NNode load(@CheckForNull Object jElement) {
        if (jElement == null) {
            return null;
        }
        NNode node = this.factory.createNNode(jElement);
        if (node != null) {
            node.importFromJast(this, jElement);
        } else assert (jElement instanceof Marker && !(jElement instanceof SerializableMarker));
        return node;
    }

    @CheckForNull
    public NSourceInfo load(@CheckForNull SourceInfo sourceInfo) {
        if (sourceInfo == null) {
            return null;
        }
        if (sourceInfo == SourceInfo.UNKNOWN) {
            return NSourceInfo.UNKNOWN;
        }
        NSourceInfo nSourceInfo = new NSourceInfo();
        nSourceInfo.importFromJast(sourceInfo);
        return nSourceInfo;
    }

    @Nonnull
    public <T extends NNode> List<T> load(@Nonnull Class<T> nodeClass, @Nonnull Iterable<?> jElements) {
        ArrayList<NNode> nodes = new ArrayList<NNode>();
        for (Object jElement : jElements) {
            NNode node = this.load(jElement);
            if (node == null) continue;
            assert (nodeClass.isAssignableFrom(node.getClass()));
            nodes.add(node);
        }
        return nodes;
    }

    @Nonnull
    public <T> List<String> getIds(SymbolManager<T> symbolManager, List<? extends T> nodes) {
        ArrayList<String> ids = new ArrayList<String>(nodes.size());
        for (T node : nodes) {
            ids.add(symbolManager.getId(node));
        }
        return ids;
    }

    @Nonnull
    public SymbolManager<JCatchBlock> getCatchBlockSymbols() {
        return this.catchBlockSymbols;
    }

    @Nonnull
    public SymbolManager<JCaseStatement> getCaseSymbols() {
        return this.caseSymbols;
    }

    @Nonnull
    public SymbolManager<JField> getFieldSymbols() {
        return this.fieldSymbols;
    }

    @Nonnull
    public SymbolManager<JParameter> getParameterSymbols() {
        return this.parameterSymbols;
    }

    @Nonnull
    public SymbolManager<JLocal> getLocalSymbols() {
        return this.localSymbols;
    }

    @Nonnull
    public SymbolManager<JLabeledStatement> getLabelSymbols() {
        return this.labelSymbols;
    }

    @CheckForNull
    public static String getMethodClassSignature(@CheckForNull JMethod method) {
        return method != null ? NNode.getFormatter().getName(method.getEnclosingType()) : null;
    }

    @Nonnull
    public static List<String> getMethodArgsSignature(@Nonnull JMethodIdWide methodId) {
        List<JType> argTypes = methodId.getParamTypes();
        if (argTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> argsTypeAsSignature = new ArrayList<String>(argTypes.size());
        for (JType type : argTypes) {
            argsTypeAsSignature.add(NNode.getFormatter().getName(type));
        }
        return argsTypeAsSignature;
    }
}

