/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.LibraryException;
import com.android.jack.backend.jayce.JayceFileImporter;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPackageLookupException;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.MissingJTypeLookupException;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.library.FileType;
import com.android.jack.library.HasInputLibrary;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryReadingException;
import com.android.jack.load.PackageLoader;
import com.android.jack.reporting.Reporter;
import com.android.jack.util.collect.UnmodifiableCollections;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.InputVDir;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.InputVFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@VariableName(value="loader")
public class JaycePackageLoader
implements PackageLoader,
HasInputLibrary {
    @Nonnull
    private final InputVDir packageVDir;
    @Nonnull
    private final JSession session;
    @Nonnull
    private final NodeLevel defaultLoadLevel;
    @Nonnull
    private final InputJackLibrary inputJackLibrary;
    @Nonnull
    private final Map<String, InputVDir> vdirCache = new HashMap<String, InputVDir>();
    @Nonnull
    private final Map<String, InputVFile> jayceFileCache = new HashMap<String, InputVFile>();
    @Nonnull
    private final UnmodifiableCollections collections = Jack.getUnmodifiableCollections();

    JaycePackageLoader(@Nonnull InputJackLibrary inputJackLibrary, @Nonnull InputVDir packageVDir, @Nonnull JSession session, @Nonnull NodeLevel defaultLoadLevel) {
        assert (inputJackLibrary.containsFileType(FileType.JAYCE));
        this.inputJackLibrary = inputJackLibrary;
        this.packageVDir = packageVDir;
        this.session = session;
        this.defaultLoadLevel = defaultLoadLevel;
        for (InputVElement inputVElement : packageVDir.list()) {
            String name = inputVElement.getName();
            if (inputVElement.isVDir()) {
                this.vdirCache.put(name, (InputVDir)inputVElement);
                continue;
            }
            if (!JayceFileImporter.isJackFileName(name)) continue;
            this.jayceFileCache.put(name.substring(0, name.length() - JayceFileImporter.JACK_EXTENSION_LENGTH), (InputVFile)inputVElement);
        }
    }

    @Override
    @Nonnull
    public JDefinedClassOrInterface loadClassOrInterface(@Nonnull JPackage loading, @Nonnull String simpleName) throws MissingJTypeLookupException {
        InputVFile inputVFile = this.jayceFileCache.get(simpleName);
        if (inputVFile == null) {
            throw new MissingJTypeLookupException(loading, simpleName);
        }
        try {
            return new JayceClassOrInterfaceLoader(this.inputJackLibrary, loading, simpleName, inputVFile, this.session, this.defaultLoadLevel).load();
        }
        catch (LibraryException e) {
            LibraryReadingException reportable = new LibraryReadingException(e);
            Jack.getSession().getReporter().report(Reporter.Severity.FATAL, reportable);
            throw new JackAbortException(reportable);
        }
    }

    @Override
    @Nonnull
    public Collection<String> getSubClassNames(@Nonnull JPackage loading) {
        return this.collections.getUnmodifiableCollection(this.jayceFileCache.keySet());
    }

    @Override
    @Nonnull
    public PackageLoader getLoaderForSubPackage(@Nonnull JPackage loading, @Nonnull String simpleName) throws JPackageLookupException {
        InputVDir input = this.vdirCache.get(simpleName);
        if (input == null) {
            throw new JPackageLookupException(simpleName, loading);
        }
        return new JaycePackageLoader(this.inputJackLibrary, input, this.session, this.defaultLoadLevel);
    }

    @Override
    @Nonnull
    public Collection<String> getSubPackageNames(@Nonnull JPackage loading) {
        return this.collections.getUnmodifiableCollection(this.vdirCache.keySet());
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JPackage loaded) {
        return this.packageVDir.getLocation();
    }

    @Override
    public boolean isOnPath(@Nonnull JPackage loaded) {
        return true;
    }

    @Override
    @Nonnull
    public InputLibrary getInputLibrary() {
        return this.inputJackLibrary;
    }
}

