/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.jayce.JayceFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class JayceHeader {
    private static final char VERSION_SEPARATOR = '.';
    private static final char STRING_DELIMITER = '\"';
    private static final char VALUE_SEPARATOR = ' ';
    private static final char LEFT_BRACKET = '(';
    private static final char RIGHT_BRACKET = ')';
    @Nonnull
    private static final String JAYCE_KEYWORD = "jayce";
    @Nonnull
    private static final Charset DEFAULT_CHARSET = Charset.forName("US-ASCII");
    @Nonnull
    private static final byte[] JAYCE_KEYWORD_BYTE_ARRAY = "jayce".getBytes(DEFAULT_CHARSET);
    @Nonnull
    private static final String STANDARD_ERROR_MESSAGE = "Invalid Jayce header";
    @Nonnegative
    private static final int INT_MAX_DIGITS = String.valueOf(Integer.MAX_VALUE).length();
    @Nonnegative
    private static final int EMITTER_ID_MAX_LENGTH = 1024;
    @Nonnull
    private static final String VERSION_FORMAT = "%04d";
    @Nonnegative
    private int majorVersion;
    @Nonnegative
    private int minorVersion;
    @CheckForNull
    private String emitterId = null;
    private char previousChar;

    public JayceHeader(@Nonnull InputStream is) throws IOException, JayceFormatException {
        this.readHeader(is);
    }

    private void readHeader(@Nonnull InputStream in) throws IOException, JayceFormatException {
        this.checkJayceKeyword(in);
        this.checkLeftBracket(this.readChar(in));
        this.majorVersion = this.readInt(in);
        this.checkVersionSeparator(this.getPreviousChar());
        this.minorVersion = this.readInt(in);
        if (this.checkIfRightBracket(this.getPreviousChar())) {
            return;
        }
        this.emitterId = this.readString(in, 1024);
        if (!this.checkIfRightBracket(this.readChar(in))) {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
    }

    private void checkLeftBracket(char readChar) throws JayceFormatException {
        if (readChar != '(') {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
    }

    private boolean checkIfRightBracket(char readChar) throws JayceFormatException {
        if (readChar == ')') {
            return true;
        }
        if (readChar != ' ') {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
        return false;
    }

    private void checkVersionSeparator(char potentialSeparator) throws JayceFormatException {
        if (potentialSeparator != '.') {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
    }

    private void checkJayceKeyword(@Nonnull InputStream in) throws IOException, JayceFormatException {
        byte[] byteArray = new byte[JAYCE_KEYWORD_BYTE_ARRAY.length];
        if (in.read(byteArray) != -1) {
            if (!Arrays.equals(byteArray, JAYCE_KEYWORD_BYTE_ARRAY)) {
                throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
            }
        } else {
            throw new JayceFormatException("No Jayce header found");
        }
    }

    private int readInt(@Nonnull InputStream in) throws IOException, JayceFormatException {
        StringBuffer buffer = new StringBuffer(2);
        char readChar = this.readChar(in);
        int numRead = 1;
        while (Character.isDigit(readChar)) {
            if (numRead > INT_MAX_DIGITS) {
                throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
            }
            buffer.append(readChar);
            readChar = this.readChar(in);
            ++numRead;
        }
        try {
            return Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException e) {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
    }

    @Nonnull
    private String readString(@Nonnull InputStream in, int upperLimit) throws IOException, JayceFormatException {
        char readChar = this.readChar(in);
        if (readChar != '\"') {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
        StringBuffer buffer = new StringBuffer(upperLimit);
        readChar = this.readChar(in);
        int numRead = 1;
        while (readChar != '\"') {
            if (numRead > upperLimit) {
                throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
            }
            buffer.append(readChar);
            readChar = this.readChar(in);
            ++numRead;
        }
        return buffer.toString();
    }

    public void writeHeader(@Nonnull OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, DEFAULT_CHARSET);
        writer.append(JAYCE_KEYWORD);
        writer.append('(');
        writer.append(String.valueOf(this.majorVersion));
        writer.append('.');
        writer.append(String.valueOf(this.minorVersion));
        if (this.emitterId != null) {
            writer.append(' ');
            writer.append('\"');
            writer.append(this.emitterId);
            writer.append('\"');
        }
        writer.append(')');
        writer.flush();
    }

    @Nonnegative
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Nonnegative
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Nonnull
    public String getMajorVersionString() {
        return JayceHeader.getVersionString(this.majorVersion);
    }

    @Nonnull
    public static String getVersionString(@Nonnegative int version) {
        return String.format(VERSION_FORMAT, version);
    }

    @CheckForNull
    public String getEmitterId() {
        return this.emitterId;
    }

    private char readChar(@Nonnull InputStream in) throws IOException, JayceFormatException {
        int readChar = in.read();
        if (readChar == 9) {
            readChar = 32;
        }
        if (this.previousChar == ' ') {
            while (readChar == 32) {
                readChar = in.read();
            }
        }
        if (readChar == -1) {
            throw new JayceFormatException(STANDARD_ERROR_MESSAGE);
        }
        this.previousChar = (char)readChar;
        return this.previousChar;
    }

    private char getPreviousChar() {
        return this.previousChar;
    }
}

