/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.naming;

import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.PackageFormatter;
import com.android.jack.ir.formatter.SourceFormatter;
import com.android.jack.ir.naming.AbstractName;
import javax.annotation.Nonnull;

public class PackageName
extends AbstractName {
    @Nonnull
    private static final PackageFormatter binaryQnFormatter = BinaryQualifiedNameFormatter.getFormatter();
    @Nonnull
    private static final PackageFormatter sourceQnFormatter = SourceFormatter.getFormatter();
    @Nonnull
    private final JPackage pack;
    @Nonnull
    private final Kind kind;

    public PackageName(@Nonnull Kind kind, @Nonnull JPackage pack) {
        this.kind = kind;
        this.pack = pack;
    }

    @Nonnull
    private static String getValue(@Nonnull JPackage pack, @Nonnull Kind kind) {
        switch (kind) {
            case BINARY_QN: {
                return binaryQnFormatter.getName(pack);
            }
            case SRC_QN: {
                return sourceQnFormatter.getName(pack);
            }
            case SIMPLE_NAME: {
                return pack.getName();
            }
        }
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public String toString() {
        return PackageName.getValue(this.pack, this.kind);
    }

    @Nonnull
    public JPackage getReferencedPackage() {
        return this.pack;
    }

    public static enum Kind {
        BINARY_QN,
        SRC_QN,
        SIMPLE_NAME;

    }
}

