/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.impl;

import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.impl.BaseGenerationVisitor;
import com.android.jack.util.TextOutput;
import javax.annotation.Nonnull;

public class ToStringGenerationVisitor
extends BaseGenerationVisitor {
    public ToStringGenerationVisitor(TextOutput textOutput) {
        super(textOutput);
    }

    @Override
    public boolean visit(@Nonnull JDefinedClass x) {
        this.printTypeFlags(x);
        this.print(CHARS_CLASS);
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JConstructor x) {
        if (x.isPrivate()) {
            this.print(CHARS_PRIVATE);
        } else {
            this.print(CHARS_PUBLIC);
        }
        this.printName(x);
        this.printParameterList(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JField x) {
        this.print(JModifier.getStringFieldModifier(x.getModifier()));
        this.printType(x);
        this.space();
        this.printTypeName(x.getEnclosingType());
        this.print('.');
        this.printName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDefinedInterface x) {
        this.printTypeFlags(x);
        this.print(CHARS_INTERFACE);
        this.printTypeName(x);
        return false;
    }

    @Override
    public boolean visit(@Nonnull JMethod x) {
        JLiteral defaultValue;
        this.printMethodHeader(x);
        if (x instanceof JAnnotationMethod && (defaultValue = ((JAnnotationMethod)x).getDefaultValue()) != null) {
            this.space();
            this.print(CHARS_DEFAULT);
            this.space();
            this.accept(defaultValue);
        }
        return false;
    }

    @Override
    protected void printMethodHeader(JMethod x) {
        this.print(JModifier.getStringMethodModifier(x.getModifier()));
        this.printType(x);
        this.space();
        this.printTypeName(x.getEnclosingType());
        this.print('.');
        this.printName(x);
        this.printParameterList(x);
    }
}

