/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Java while statement")
public class JWhileStatement
extends JStatement
implements JLoop {
    private JStatement body;
    private JExpression testExpr;

    public JWhileStatement(SourceInfo info, JExpression testExpr, JStatement body) {
        super(info);
        this.testExpr = testExpr;
        this.body = body;
    }

    public JStatement getBody() {
        return this.body;
    }

    public JExpression getTestExpr() {
        return this.testExpr;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.testExpr);
            if (this.body != null) {
                visitor.accept(this.body);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.testExpr.traverse(schedule);
        if (this.body != null) {
            this.body.traverse(schedule);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.testExpr == existingNode) {
            this.testExpr = (JExpression)newNode;
        } else if (this.body == existingNode) {
            this.body = (JStatement)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.body == existingNode) {
            this.body = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

