/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Java method call expression")
public class JPolymorphicMethodCall
extends JAbstractMethodCall {
    @Nonnull
    private final JType callSiteReturnType;

    @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"})
    public JPolymorphicMethodCall(@Nonnull SourceInfo info, @Nonnull JExpression instance, @Nonnull JClassOrInterface receiverType, @Nonnull JMethodId methodId, @Nonnull JType callSiteReturnType) {
        super(info, instance, receiverType, methodId.getMethodIdWide(), methodId.getType());
        assert (instance != null);
        assert (JPolymorphicMethodCall.isCallToPolymorphicMethod(receiverType, methodId.getMethodIdWide(), methodId.getType()));
        this.callSiteReturnType = callSiteReturnType;
    }

    public JType getReturnTypeOfPolymorphicMethod() {
        return super.getType();
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.callSiteReturnType;
    }

    @Nonnull
    public List<JType> getCallSiteParameterTypes() {
        JClass jlv = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_VOID);
        ArrayList<JType> callSiteParameterTypes = new ArrayList<JType>(this.getArgs().size());
        for (JExpression pExp : this.getArgs()) {
            if (pExp instanceof JNullLiteral) {
                callSiteParameterTypes.add(jlv);
                continue;
            }
            callSiteParameterTypes.add(pExp.getType());
        }
        return callSiteParameterTypes;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        JExpression instance = this.getInstance();
        if (instance == null) {
            throw new JNodeInternalError(this, "Call to method with polymorphic signature must not be static");
        }
        if (!this.getReceiverType().isSameType(instance.getType())) {
            throw new JNodeInternalError(this, "Receiver type mismatch with instance type");
        }
    }
}

