/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.HasEnclosingMethod;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JParameterRef;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.NopParameterLoader;
import com.android.jack.load.ParameterLoader;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java method parameter definition")
public class JParameter
extends JVariable
implements HasEnclosingMethod {
    @CheckForNull
    private final JMethod enclosingMethod;
    @Nonnull
    private ParameterLoader loader;

    public JParameter(@Nonnull SourceInfo info, @CheckForNull String name, @Nonnull JType type, int modifier, @Nonnull JMethod enclosingMethod) {
        this(info, name, type, modifier, enclosingMethod, NopParameterLoader.INSTANCE);
    }

    public JParameter(@Nonnull SourceInfo info, @CheckForNull String name, @Nonnull JType type, int modifier, @Nonnull JMethod enclosingMethod, @Nonnull ParameterLoader loader) {
        super(info, name, type, modifier);
        assert (JModifier.isParameterModifier(modifier));
        this.enclosingMethod = enclosingMethod;
        this.loader = loader;
    }

    JParameter(@Nonnull SourceInfo info, @CheckForNull String name, @Nonnull JType type, int modifier) {
        super(info, name, type, modifier);
        this.enclosingMethod = null;
        this.loader = NopParameterLoader.INSTANCE;
    }

    @Override
    @Nonnull
    public JMethod getEnclosingMethod() {
        assert (this.enclosingMethod != null);
        return this.enclosingMethod;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor.needLoading()) {
                this.loader.ensureAnnotations(this);
            }
            visitor.accept(this.annotations);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    @Nonnull
    public List<JAnnotation> getAnnotations(@Nonnull JAnnotationType annotationType) {
        this.loader.ensureAnnotation(this, annotationType);
        return super.getAnnotations(annotationType);
    }

    @Override
    @Nonnull
    public Collection<JAnnotation> getAnnotations() {
        this.loader.ensureAnnotations(this);
        return super.getAnnotations();
    }

    @Override
    @Nonnull
    public Set<JAnnotationType> getAnnotationTypes() {
        this.loader.ensureAnnotations(this);
        return super.getAnnotationTypes();
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JMethod)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
        if (this.parent != this.enclosingMethod) {
            throw new JNodeInternalError(this, "Invalid parent or enclosing method");
        }
    }

    @Override
    @Nonnull
    public JParameterRef makeRef(@Nonnull SourceInfo info) {
        return new JParameterRef(info, this);
    }

    @Override
    @CheckForNull
    public <T extends Marker> T getMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.getMarker(cls);
    }

    @Override
    @Nonnull
    public Collection<Marker> getAllMarkers() {
        this.loader.ensureMarkers(this);
        return super.getAllMarkers();
    }

    @Override
    public <T extends Marker> boolean containsMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.containsMarker(cls);
    }

    @Override
    public <T extends Marker> T removeMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.removeMarker(cls);
    }

    public void removeLoader() {
        this.loader = NopParameterLoader.INSTANCE;
    }
}

