/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.naming.MethodName;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="String representing the name of a method")
public class JMethodNameLiteral
extends JAbstractStringLiteral {
    @Nonnull
    private final MethodName methodName;

    public JMethodNameLiteral(@Nonnull SourceInfo sourceInfo, @Nonnull JMethod method) {
        super(sourceInfo);
        this.methodName = new MethodName(method);
    }

    @Override
    @Nonnull
    public String getValue() {
        return this.methodName.toString();
    }

    @Nonnull
    public JMethod getMethod() {
        return this.methodName.getMethod();
    }

    @Override
    @Nonnull
    public JMethodNameLiteral clone() {
        return (JMethodNameLiteral)super.clone();
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

