/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.HierarchyFilter;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.sched.item.Component;
import com.android.sched.marker.LocalMarkerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Deprecated
public class JMethodIdWide
extends LocalMarkerManager
implements HasName,
CanBeRenamed,
Component {
    @Nonnull
    private String name;
    @Nonnull
    private final List<JType> paramTypes = new ArrayList<JType>();
    @Nonnull
    private final Map<JType, JMethodId> methodIds = new HashMap<JType, JMethodId>();
    @Nonnull
    private MethodKind methodKind;

    public JMethodIdWide(@Nonnull String name, @Nonnull MethodKind kind) {
        assert (!name.contains("(") && !name.contains(")"));
        assert (!"<init>".equals(name) && !"<clinit>".equals(name) || kind != MethodKind.INSTANCE_VIRTUAL);
        this.name = StringInterner.get().intern(name);
        this.methodKind = kind;
    }

    public JMethodIdWide(@Nonnull String name, @Nonnull List<? extends JType> paramTypes, @Nonnull MethodKind methodKind) {
        this(name, methodKind);
        this.paramTypes.addAll(paramTypes);
    }

    public void addParam(@Nonnull JType x) {
        this.paramTypes.add(x);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Collection<JMethod> getMethods() {
        ArrayList<JMethod> methods = new ArrayList<JMethod>();
        for (JMethodId id : this.methodIds.values()) {
            methods.addAll(id.getMethods());
        }
        return methods;
    }

    @Nonnull
    public Collection<JMethodId> getMethodIds() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.methodIds.values());
    }

    @Nonnull
    public Collection<JMethod> getMethods(@Nonnull JReferenceType reference, @Nonnull HierarchyFilter filter) {
        Collection<JMethod> methods = this.getMethods();
        ArrayList<JMethod> subset = new ArrayList<JMethod>(methods.size());
        switch (filter) {
            case SUPER_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!reference.canBeSafelyUpcast(jMethod.getEnclosingType())) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case SUB_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!jMethod.getEnclosingType().canBeSafelyUpcast(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case SUB_AND_SUPER_TYPES: {
                for (JMethod jMethod : methods) {
                    if (!reference.canBeSafelyUpcast(jMethod.getEnclosingType()) && !jMethod.getEnclosingType().canBeSafelyUpcast(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            case THIS_TYPE: {
                for (JMethod jMethod : methods) {
                    if (!jMethod.getEnclosingType().isSameType(reference)) continue;
                    subset.add(jMethod);
                }
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return subset;
    }

    @Nonnull
    public List<JType> getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public void setName(@Nonnull String newName) {
        assert (!newName.contains("(") && !newName.contains(")"));
        this.name = StringInterner.get().intern(newName);
    }

    boolean equals(@Nonnull String otherName, @Nonnull List<? extends JType> otherParamTypes, @Nonnull MethodKind kind) {
        if (this.methodKind != kind) {
            return false;
        }
        return this.equals(otherName, otherParamTypes);
    }

    public boolean equals(@Nonnull String otherName, @Nonnull List<? extends JType> otherParamTypes) {
        if (!this.name.equals(otherName) || this.paramTypes.size() != otherParamTypes.size()) {
            return false;
        }
        Iterator<? extends JType> otherParams = otherParamTypes.iterator();
        for (JType param : this.paramTypes) {
            if (param.isSameType(otherParams.next())) continue;
            return false;
        }
        return true;
    }

    public void addMethodId(@Nonnull JMethodId methodId) {
        this.methodIds.put(methodId.getType(), methodId);
        assert (this.canBeResultId());
    }

    @CheckForNull
    public JMethodId getMethodId(@Nonnull JType returnType) {
        return this.methodIds.get(returnType);
    }

    @Nonnull
    public MethodKind getKind() {
        return this.methodKind;
    }

    @Deprecated
    public void setKind(@Nonnull MethodKind methodKind) {
        assert (this.getMethods().size() == 1);
        assert (methodKind != MethodKind.INSTANCE_VIRTUAL);
        assert (this.methodKind != MethodKind.INSTANCE_VIRTUAL);
        this.methodKind = methodKind;
    }

    public boolean canBeVirtual() {
        return this.methodKind == MethodKind.INSTANCE_VIRTUAL;
    }

    private boolean canBeResultId() {
        for (JMethodId id : this.methodIds.values()) {
            if (id.getMethodIdWide().equals(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isInit() {
        return this.name.equals("<init>");
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(@CheckForNull Object obj) {
        return obj == this;
    }
}

