/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Represents a the body of a Java method")
public class JMethodBody
extends JAbstractMethodBody {
    @Nonnull
    private JBlock block;
    @Nonnull
    private final List<JLocal> locals = new LinkedList<JLocal>();

    public JMethodBody(@Nonnull SourceInfo info, @Nonnull JBlock block) {
        super(info);
        this.block = block;
    }

    public void addLocal(@Nonnull JLocal local) {
        this.locals.add(local);
    }

    @Nonnull
    public JBlock getBlock() {
        return this.block;
    }

    @Nonnull
    public List<JLocal> getLocals() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.locals);
    }

    @Nonnull
    public List<JStatement> getStatements() {
        return this.block.getStatements();
    }

    @Override
    public boolean isNative() {
        return false;
    }

    public void removeLocal(@Nonnull JLocal localToDelete) {
        this.locals.remove(localToDelete);
    }

    public void removeLocals(@Nonnull List<JLocal> localsToDelete) {
        this.locals.removeAll(localsToDelete);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.locals);
            visitor.accept(this.block);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JLocal local : this.locals) {
            local.traverse(schedule);
        }
        this.block.traverse(schedule);
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JMethodBody.transform(this.locals, existingNode, (JLocal)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.block == existingNode) {
            this.block = (JBlock)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

