/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBinaryOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Description;
import javax.annotation.Nonnull;

@Description(value="Logical and bitwise expression")
public abstract class JLogicalAndBitwiseOperation
extends JBinaryOperation {
    public JLogicalAndBitwiseOperation(@Nonnull SourceInfo info, @Nonnull JExpression lhs, @Nonnull JExpression rhs) {
        super(info, lhs, rhs);
    }

    @Override
    public JType getType() {
        JType lhsType = this.getLhs().getType();
        JType rhsType = this.getRhs().getType();
        if (JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().isEquivalent(lhsType) && JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().isEquivalent(rhsType)) {
            return JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType();
        }
        assert (JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isEquivalent(lhsType) || JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().isEquivalent(lhsType) || JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isEquivalent(lhsType) || JPrimitiveType.JPrimitiveTypeEnum.INT.getType().isEquivalent(lhsType) || JPrimitiveType.JPrimitiveTypeEnum.LONG.getType().isEquivalent(lhsType));
        assert (JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isEquivalent(rhsType) || JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().isEquivalent(rhsType) || JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isEquivalent(rhsType) || JPrimitiveType.JPrimitiveTypeEnum.INT.getType().isEquivalent(rhsType) || JPrimitiveType.JPrimitiveTypeEnum.LONG.getType().isEquivalent(rhsType));
        return JPrimitiveType.getBinaryPromotionType(lhsType, rhsType);
    }
}

