/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.HasEnclosingMethod;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java local variable definition")
public class JLocal
extends JVariable
implements HasEnclosingMethod {
    @CheckForNull
    private JMethodBody enclosingMethodBody;

    public JLocal(SourceInfo info, String name, JType type, int modifier, @CheckForNull JMethodBody enclosingMethodBody) {
        super(info, name, type, modifier);
        assert (JModifier.isLocalModifier(modifier));
        this.enclosingMethodBody = enclosingMethodBody;
    }

    @Override
    @CheckForNull
    public JMethod getEnclosingMethod() {
        JMethodBody enclosingMethodBodyLocal = this.enclosingMethodBody;
        if (enclosingMethodBodyLocal != null) {
            return enclosingMethodBodyLocal.method;
        }
        return null;
    }

    public void setEnclosingMethodBody(@Nonnull JMethodBody enclosingMethodBody) {
        this.enclosingMethodBody = enclosingMethodBody;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.annotations);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JMethodBody) && !(this.parent instanceof JCatchBlock)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }

    @Override
    @Nonnull
    public JLocalRef makeRef(@Nonnull SourceInfo info) {
        return new JLocalRef(info, this);
    }
}

