/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java for statement")
public class JForStatement
extends JStatement
implements JLoop {
    private JStatement body;
    private final List<JExpressionStatement> increments;
    private final List<JStatement> initializers;
    private JExpression testExpr;

    public JForStatement(SourceInfo info, List<JStatement> initializers, JExpression testExpr, List<JExpressionStatement> increments, JStatement body) {
        super(info);
        this.initializers = initializers;
        this.testExpr = testExpr;
        this.increments = increments;
        this.body = body;
    }

    public JStatement getBody() {
        return this.body;
    }

    public List<JExpressionStatement> getIncrements() {
        return this.increments;
    }

    public List<JStatement> getInitializers() {
        return this.initializers;
    }

    public JExpression getTestExpr() {
        return this.testExpr;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.initializers);
            if (this.testExpr != null) {
                visitor.accept(this.testExpr);
            }
            visitor.accept(this.increments);
            if (this.body != null) {
                visitor.accept(this.body);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JStatement initializer : this.initializers) {
            initializer.traverse(schedule);
        }
        if (this.testExpr != null) {
            this.testExpr.traverse(schedule);
        }
        for (JExpressionStatement increment : this.increments) {
            increment.traverse(schedule);
        }
        if (this.body != null) {
            this.body.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JForStatement.transform(this.increments, existingNode, (JExpressionStatement)newNode, transformation) && !JForStatement.transform(this.initializers, existingNode, (JStatement)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) {
        assert (newNode != null);
        if (this.testExpr == existingNode) {
            this.testExpr = (JExpression)newNode;
        } else if (this.body == existingNode) {
            this.body = (JStatement)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.testExpr == existingNode) {
            this.testExpr = null;
        } else if (this.body == existingNode) {
            this.body = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

