/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java field reference expression")
public class JFieldRef
extends JExpression {
    @Nonnull
    private JClassOrInterface receiverType;
    @Nonnull
    private final JFieldId fieldId;
    @CheckForNull
    private JExpression instance;

    public JFieldRef(@Nonnull SourceInfo info, @CheckForNull JExpression instance, @Nonnull JFieldId fieldId, @Nonnull JClassOrInterface receiverType) {
        super(info);
        assert (instance != null || fieldId.getKind() == FieldKind.STATIC);
        this.fieldId = fieldId;
        this.instance = instance;
        this.receiverType = receiverType;
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.fieldId.getType();
    }

    public void setReceiverType(@Nonnull JClassOrInterface receiverType) {
        this.receiverType = receiverType;
    }

    @Nonnull
    public JClassOrInterface getReceiverType() {
        return this.receiverType;
    }

    @Nonnull
    public JFieldId getFieldId() {
        return this.fieldId;
    }

    @CheckForNull
    public JExpression getInstance() {
        return this.instance;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this) && this.instance != null) {
            visitor.accept(this.instance);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        if (this.instance != null) {
            this.instance.traverse(schedule);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.instance == existingNode) {
            this.instance = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.instance == existingNode) {
            this.instance = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

