/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JType;
import com.android.sched.item.Component;
import com.android.sched.marker.LocalMarkerManager;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JFieldId
extends LocalMarkerManager
implements HasName,
CanBeRenamed,
HasType,
Component {
    @Nonnull
    private String name;
    @Nonnull
    private final JType type;
    @Nonnull
    private final FieldKind kind;
    @CheckForNull
    private JField field;

    public JFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) {
        this.name = StringInterner.get().intern(name);
        this.type = type;
        this.kind = kind;
    }

    public JFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind, @Nonnull JField field) {
        this(name, type, kind);
        this.field = field;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.type;
    }

    @Override
    public void setName(@Nonnull String name) {
        this.name = StringInterner.get().intern(name);
    }

    @Nonnull
    public FieldKind getKind() {
        return this.kind;
    }

    public String toString() {
        return this.name + " : " + Jack.getUserFriendlyFormatter().getName(this.type);
    }

    @CheckForNull
    public JField getField() {
        return this.field;
    }

    public boolean equals(@Nonnull String otherName, @Nonnull JType otherType, @Nonnull FieldKind otherKind) {
        if (this.kind != otherKind || !this.name.equals(otherName)) {
            return false;
        }
        return this.type.isSameType(otherType);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(@CheckForNull Object obj) {
        return obj == this;
    }
}

