/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Java cast expression with multiple target types that can throw at runtime")
public class JDynamicCastOperation
extends JCastOperation {
    @Nonnull
    private final List<JType> castTypes;

    public JDynamicCastOperation(@Nonnull SourceInfo info, @Nonnull JExpression expr, JType ... castTypes) {
        super(info, expr);
        this.castTypes = Arrays.asList(castTypes);
        assert (!this.castTypes.isEmpty());
        assert (this.castTypes.size() == 1 || !this.hasJPrimitiveType());
    }

    public JDynamicCastOperation(@Nonnull SourceInfo info, @Nonnull JExpression expr, @Nonnull List<JType> castTypes) {
        super(info, expr);
        this.castTypes = castTypes;
        assert (!this.castTypes.isEmpty());
    }

    @Nonnull
    public List<JType> getTypes() {
        return this.castTypes;
    }

    @Override
    @Nonnull
    public JType getType() {
        assert (this.castTypes.size() == 1);
        return this.castTypes.iterator().next();
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.expr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.expr.traverse(schedule);
    }

    @Override
    public boolean canThrow() {
        if (this.castTypes.size() > 1) {
            return true;
        }
        return !(this.getType() instanceof JPrimitiveType) || !(this.getExpr().getType() instanceof JPrimitiveType);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    private boolean hasJPrimitiveType() {
        for (JType type : this.castTypes) {
            if (!(type instanceof JPrimitiveType)) continue;
            return true;
        }
        return false;
    }
}

