/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.CanBeAbstract;
import com.android.jack.ir.ast.CanBeFinal;
import com.android.jack.ir.ast.FieldKind;
import com.android.jack.ir.ast.HasEnclosingPackage;
import com.android.jack.ir.ast.HasModifier;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JDefinedReferenceType;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldLookupException;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.naming.TypeName;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.jack.load.NopClassOrInterfaceLoader;
import com.android.jack.lookup.JMethodIdLookupException;
import com.android.jack.lookup.JMethodLookupException;
import com.android.jack.lookup.JMethodWithReturnLookupException;
import com.android.jack.util.AnnotationUtils;
import com.android.jack.util.NamingTools;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Declared type")
public abstract class JDefinedClassOrInterface
extends JDefinedReferenceType
implements JClassOrInterface,
Annotable,
CanBeAbstract,
CanBeFinal,
HasLocation,
HasModifier {
    protected ArrayList<JField> fields = new ArrayList();
    protected ArrayList<JMethod> methods = new ArrayList();
    private JClassOrInterface enclosingType;
    @Nonnull
    private final List<JClassOrInterface> inners = new ArrayList<JClassOrInterface>();
    private boolean isToEmit = false;
    private int modifier;
    @Nonnull
    protected final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    @Nonnull
    private JPackage enclosingPackage;
    @Nonnull
    protected List<JMethodIdWide> phantomMethodsWide = new ArrayList<JMethodIdWide>();
    @Nonnull
    protected List<JMethodId> phantomMethods = new ArrayList<JMethodId>();
    @Nonnull
    protected List<JFieldId> phantomFields = new ArrayList<JFieldId>();
    @Nonnull
    protected ClassOrInterfaceLoader loader;
    @Nonnull
    private final Location location;

    public JDefinedClassOrInterface(@Nonnull SourceInfo info, @Nonnull String name, int modifier, @Nonnull JPackage enclosingPackage, @Nonnull ClassOrInterfaceLoader loader) {
        super(info, name);
        assert (NamingTools.isTypeIdentifier(name));
        assert (JModifier.isTypeModifier(modifier));
        assert (JModifier.isValidTypeModifier(modifier));
        this.modifier = modifier;
        this.enclosingPackage = enclosingPackage;
        this.enclosingPackage.addType(this);
        this.loader = loader;
        this.location = loader.getLocation(this);
        this.updateParents(enclosingPackage);
    }

    @Override
    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    @Nonnull
    public Collection<JClassOrInterface> getHierarchy() {
        HashSet<JClassOrInterface> hierarchy = new HashSet<JClassOrInterface>();
        for (JInterface jInterface : this.getImplements()) {
            hierarchy.add(jInterface);
            if (!(jInterface instanceof JDefinedInterface)) continue;
            hierarchy.addAll(((JDefinedInterface)jInterface).getHierarchy());
        }
        JClass superClass = this.getSuperClass();
        if (superClass != null) {
            hierarchy.add(superClass);
            if (superClass instanceof JDefinedClass) {
                hierarchy.addAll(((JDefinedClass)superClass).getHierarchy());
            }
        }
        return hierarchy;
    }

    public void addField(@Nonnull JField field) {
        assert (field.getEnclosingType() == this);
        assert (this.getPhantomField(field.getName(), field.getType(), field.getId().getKind()) == null);
        this.fields.add(field);
    }

    @Override
    @CheckForNull
    public <T extends Marker> T getMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.getMarker(cls);
    }

    @Override
    @Nonnull
    public Collection<Marker> getAllMarkers() {
        this.loader.ensureMarkers(this);
        return super.getAllMarkers();
    }

    @Override
    public <T extends Marker> boolean containsMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.containsMarker(cls);
    }

    @Override
    public <T extends Marker> T removeMarker(@Nonnull Class<T> cls) {
        this.loader.ensureMarker(this, cls);
        return super.removeMarker(cls);
    }

    @Override
    @Nonnull
    public <T extends Marker> T getMarkerOrDefault(@Nonnull T defaultMarker) {
        this.loader.ensureMarker(this, defaultMarker.getClass());
        return super.getMarkerOrDefault(defaultMarker);
    }

    @Override
    @CheckForNull
    public <T extends Marker> T addMarkerIfAbsent(@Nonnull T marker) {
        this.loader.ensureMarker(this, marker.getClass());
        return super.addMarkerIfAbsent(marker);
    }

    @Override
    public void addAllMarkers(@Nonnull Collection<Marker> collection) {
        this.loader.ensureMarkers(this);
        super.addAllMarkers(collection);
    }

    @Override
    @Nonnull
    public List<JInterface> getImplements() {
        this.loader.ensureHierarchy(this);
        return super.getImplements();
    }

    @Override
    public void setEnclosingPackage(@CheckForNull JPackage enclosingPackage) {
        assert (enclosingPackage != null);
        this.enclosingPackage = enclosingPackage;
        this.updateParents(enclosingPackage);
        assert (Jack.getSession().getPhantomLookup().check(this));
    }

    public void addMethod(JMethod method) {
        assert (method.getEnclosingType() == this);
        assert (this.getPhantomMethodWide(method.getName(), method.getMethodIdWide().getParamTypes(), method.getMethodIdWide().getKind()) == null);
        this.methods.add(method);
    }

    public JClassOrInterface getEnclosingType() {
        this.loader.ensureEnclosing(this);
        return this.enclosingType;
    }

    public List<JField> getFields() {
        this.loader.ensureFields(this);
        return this.fields;
    }

    @Nonnull
    public List<JField> getFields(@Nonnull String fieldName) {
        this.loader.ensureFields(this, fieldName);
        ArrayList<JField> fieldsFound = new ArrayList<JField>();
        for (JField field : this.getFields()) {
            if (!field.getName().equals(fieldName)) continue;
            fieldsFound.add(field);
        }
        return fieldsFound;
    }

    @Override
    @Nonnull
    public JPackage getEnclosingPackage() {
        return this.enclosingPackage;
    }

    public List<JMethod> getMethods() {
        this.loader.ensureMethods(this);
        return this.methods;
    }

    @Nonnull
    public JMethod getMethod(@Nonnull String name, @Nonnull JType returnType, @Nonnull List<? extends JType> args) throws JMethodLookupException {
        this.loader.ensureMethod(this, name, args, returnType);
        for (JMethod m : this.methods) {
            if (!m.getMethodIdWide().equals(name, args) || !m.getType().isSameType(returnType)) continue;
            return m;
        }
        throw new JMethodWithReturnLookupException(this, name, args, returnType);
    }

    @Nonnull
    public JMethod getMethod(@Nonnull String name, @Nonnull JType returnType, JType ... args) throws JMethodLookupException {
        return this.getMethod(name, returnType, Arrays.asList(args));
    }

    @Override
    public boolean isToEmit() {
        return this.isToEmit;
    }

    public void setEnclosingType(JClassOrInterface enclosingType) {
        this.enclosingType = enclosingType;
    }

    public void setToEmit(boolean isToEmit) {
        this.isToEmit = isToEmit;
    }

    @Override
    public int getModifier() {
        this.loader.ensureModifier(this);
        return this.modifier;
    }

    public boolean isPublic() {
        return JModifier.isPublic(this.getModifier());
    }

    public boolean isProtected() {
        return JModifier.isProtected(this.getModifier());
    }

    public boolean isPrivate() {
        return JModifier.isPrivate(this.getModifier());
    }

    public boolean isStatic() {
        return JModifier.isStatic(this.getModifier());
    }

    public boolean isStrictfp() {
        return JModifier.isStrictfp(this.getModifier());
    }

    public boolean isSynthetic() {
        return JModifier.isSynthetic(this.getModifier());
    }

    @Override
    public boolean isAbstract() {
        return JModifier.isAbstract(this.getModifier());
    }

    public boolean isAnonymous() {
        return TypeName.getSimpleName(this).isEmpty();
    }

    public void setAbstract() {
        this.modifier = this.getModifier() | 0x400;
    }

    @Override
    public boolean isFinal() {
        return JModifier.isFinal(this.getModifier());
    }

    public void setFinal() {
        this.modifier = this.getModifier() | 0x10;
    }

    @Override
    public void addAnnotation(@Nonnull JAnnotation annotation) {
        this.annotations.add(annotation);
    }

    @Nonnull
    public List<JAnnotation> getAnnotations(@Nonnull JAnnotationType annotationType) {
        this.loader.ensureAnnotation(this, annotationType);
        return Jack.getUnmodifiableCollections().getUnmodifiableList(AnnotationUtils.getAnnotation(this.annotations, annotationType));
    }

    @Override
    @Nonnull
    public Collection<JAnnotation> getAnnotations() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.annotations);
    }

    @Override
    @Nonnull
    public Set<JAnnotationType> getAnnotationTypes() {
        this.loader.ensureAnnotations(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(AnnotationUtils.getAnnotationTypes(this.annotations));
    }

    @Nonnull
    public List<JClassOrInterface> getMemberTypes() {
        this.loader.ensureInners(this);
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.inners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberType(@Nonnull JClassOrInterface jDeclaredType) {
        List<JClassOrInterface> list = this.inners;
        synchronized (list) {
            this.inners.add(jDeclaredType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberType(@Nonnull JClassOrInterface jDeclaredType) {
        List<JClassOrInterface> list = this.inners;
        synchronized (list) {
            int index = this.inners.indexOf(jDeclaredType);
            if (index != -1) {
                this.inners.remove(index);
            }
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JDefinedClassOrInterface.transform(this.inners, existingNode, (JClassOrInterface)((Object)newNode), transformation) && !JDefinedClassOrInterface.transform(this.annotations, existingNode, (JAnnotation)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    @Nonnull
    public JMethodIdWide getMethodIdWide(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind) throws JMethodLookupException {
        assert (!name.contains("(") && !name.contains(")"));
        this.loader.ensureMethods(this);
        for (JMethod method : this.methods) {
            JMethodIdWide id = method.getMethodIdWide();
            if (!id.equals(name, argsType, kind)) continue;
            return id;
        }
        for (JInterface jType : this.getImplements()) {
            try {
                return jType.getMethodIdWide(name, argsType, kind);
            }
            catch (JMethodLookupException jMethodLookupException) {
            }
        }
        JClass superClass = this.getSuperClass();
        if (superClass != null) {
            try {
                return superClass.getMethodIdWide(name, argsType, kind);
            }
            catch (JMethodLookupException jMethodLookupException) {
                // empty catch block
            }
        }
        throw new JMethodIdLookupException(this, name, argsType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JMethodIdWide getOrCreateMethodIdWide(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind) {
        try {
            return this.getMethodIdWide(name, argsType, kind);
        }
        catch (JMethodLookupException e) {
            List<JMethodIdWide> list = this.phantomMethodsWide;
            synchronized (list) {
                JMethodIdWide id = this.getPhantomMethodWide(name, argsType, kind);
                if (id == null) {
                    id = new JMethodIdWide(name, argsType, kind);
                    this.phantomMethodsWide.add(id);
                }
                return id;
            }
        }
    }

    @Override
    @Nonnull
    public JMethodId getMethodId(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind, @Nonnull JType returnType) throws JMethodLookupException {
        assert (!name.contains("(") && !name.contains(")"));
        this.loader.ensureMethods(this);
        for (JMethod method : this.methods) {
            JMethodId id = method.getMethodId();
            if (!id.getType().equals(returnType) || !id.getMethodIdWide().equals(name, argsType, kind)) continue;
            return id;
        }
        for (JInterface jType : this.getImplements()) {
            try {
                return jType.getMethodId(name, argsType, kind, returnType);
            }
            catch (JMethodLookupException jMethodLookupException) {
            }
        }
        JClass superClass = this.getSuperClass();
        if (superClass != null) {
            try {
                return superClass.getMethodId(name, argsType, kind, returnType);
            }
            catch (JMethodLookupException jMethodLookupException) {
                // empty catch block
            }
        }
        throw new JMethodWithReturnLookupException(this, name, argsType, returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JMethodId getOrCreateMethodId(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind, @Nonnull JType returnType) {
        try {
            return this.getMethodId(name, argsType, kind, returnType);
        }
        catch (JMethodLookupException e) {
            List<JMethodId> list = this.phantomMethods;
            synchronized (list) {
                JMethodId id = this.getPhantomMethod(name, argsType, kind, returnType);
                if (id == null) {
                    id = new JMethodId(this.getOrCreateMethodIdWide(name, argsType, kind), returnType);
                    this.phantomMethods.add(id);
                }
                return id;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public JFieldId getOrCreateFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) {
        try {
            return this.getFieldId(name, type, kind);
        }
        catch (JFieldLookupException e) {
            List<JFieldId> list = this.phantomFields;
            synchronized (list) {
                JFieldId id = this.getPhantomField(name, type, kind);
                if (id == null) {
                    id = new JFieldId(name, type, kind);
                    this.phantomFields.add(id);
                }
                return id;
            }
        }
    }

    @Override
    @Nonnull
    public JFieldId getFieldId(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) throws JFieldLookupException {
        this.loader.ensureFields(this);
        for (JField field : this.fields) {
            JFieldId id = field.getId();
            if (!id.equals(name, type, kind)) continue;
            return id;
        }
        for (JInterface jType : this.getImplements()) {
            try {
                return jType.getFieldId(name, type, kind);
            }
            catch (JFieldLookupException jFieldLookupException) {
            }
        }
        JClass superClass = this.getSuperClass();
        if (superClass != null) {
            try {
                return superClass.getFieldId(name, type, kind);
            }
            catch (JFieldLookupException jFieldLookupException) {
                // empty catch block
            }
        }
        throw new JFieldLookupException(this, name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private JMethodId getPhantomMethod(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind, @Nonnull JType returnType) {
        List<JMethodId> list = this.phantomMethods;
        synchronized (list) {
            for (JMethodId id : this.phantomMethods) {
                if (!id.getType().equals(returnType) || !id.getMethodIdWide().equals(name, argsType, kind)) continue;
                return id;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private JMethodIdWide getPhantomMethodWide(@Nonnull String name, @Nonnull List<? extends JType> argsType, @Nonnull MethodKind kind) {
        List<JMethodIdWide> list = this.phantomMethodsWide;
        synchronized (list) {
            for (JMethodIdWide id : this.phantomMethodsWide) {
                if (!id.equals(name, argsType, kind)) continue;
                return id;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private JFieldId getPhantomField(@Nonnull String name, @Nonnull JType type, @Nonnull FieldKind kind) {
        List<JFieldId> list = this.phantomFields;
        synchronized (list) {
            for (JFieldId id : this.phantomFields) {
                if (!id.equals(name, type, kind)) continue;
                return id;
            }
        }
        return null;
    }

    @Nonnull
    public ClassOrInterfaceLoader getLoader() {
        return this.loader;
    }

    @Override
    @CheckForNull
    public JPrimitiveType getWrappedType() {
        return JDefinedClassOrInterface.getWrappedType(this);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.location;
    }

    public void removeLoader() {
        this.loader = NopClassOrInterfaceLoader.INSTANCE;
    }

    @Override
    public final boolean isSameType(@Nonnull JType type) {
        if (type instanceof HasEnclosingPackage) {
            return this.getEnclosingPackage() == ((HasEnclosingPackage)((Object)type)).getEnclosingPackage() && this.name.equals(type.getName());
        }
        return false;
    }

    @Override
    public void checkValidity() {
        if (this.parent == null || this.parent != this.enclosingPackage) {
            throw new JNodeInternalError(this, "Invalid parent or enclosing package");
        }
        for (JClassOrInterface inner : this.inners) {
            if (!(inner instanceof JDefinedClassOrInterface) || ((JDefinedClassOrInterface)inner).getEnclosingType() == this) continue;
            throw new JNodeInternalError(inner, "Invalid enclosing class or interface for member type");
        }
    }

    @Override
    public void setName(@Nonnull String name) {
        this.enclosingPackage.removeItemWithName(this);
        super.setName(name);
    }
}

