/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.CanBeSetFinal;
import com.android.jack.ir.ast.HasEnclosingMethod;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java class type reference expression")
public class JDefinedClass
extends JDefinedClassOrInterface
implements CanBeSetFinal,
JClass,
HasEnclosingMethod {
    @CheckForNull
    private JMethod enclosingMethod;

    public JDefinedClass(@Nonnull SourceInfo info, @Nonnull String name, int modifier, @Nonnull JPackage enclosingPackage, @Nonnull ClassOrInterfaceLoader loader) {
        super(info, name, modifier, enclosingPackage, loader);
    }

    @Override
    @CheckForNull
    public final JClass getSuperClass() {
        this.loader.ensureHierarchy(this);
        return super.getSuperClass();
    }

    public void setEnclosingMethod(@CheckForNull JMethod enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    @Override
    @CheckForNull
    public JMethod getEnclosingMethod() {
        this.loader.ensureEnclosing(this);
        return this.enclosingMethod;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            if (visitor.needLoading()) {
                this.loader.ensureFields(this);
                this.loader.ensureMethods(this);
                this.loader.ensureAnnotations(this);
            }
            visitor.accept(this.fields);
            visitor.accept(this.methods);
            visitor.accept(this.annotations);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JField field : this.fields) {
            field.traverse(schedule);
        }
        for (JMethod method : this.methods) {
            method.traverse(schedule);
        }
        for (JAnnotation annotation : this.annotations) {
            annotation.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (existingNode instanceof JMethod ? JDefinedClass.transform(this.methods, existingNode, (JMethod)newNode, transformation) : existingNode instanceof JField && JDefinedClass.transform(this.fields, existingNode, (JField)newNode, transformation)) {
            return;
        }
        super.transform(existingNode, newNode, transformation);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    public boolean isSubTypeOf(@Nonnull JReferenceType jclass) {
        if (jclass instanceof JClass) {
            JClass currentClass = this;
            do {
                if ((currentClass = currentClass.getSuperClass()) == null || !jclass.isSameType(currentClass)) continue;
                return true;
            } while (currentClass instanceof JDefinedClass);
        }
        return false;
    }

    private boolean canBeSafelyUpcast(@Nonnull JInterface castTo) {
        JDefinedClass currentDefinedClass;
        JClass currentClass = this;
        do {
            if (!(currentDefinedClass = currentClass).implementsInterface(castTo)) continue;
            return true;
        } while ((currentClass = currentDefinedClass.getSuperClass()) instanceof JDefinedClass);
        return false;
    }

    @Override
    public boolean canBeSafelyUpcast(@Nonnull JReferenceType castTo) {
        if (this.isTrivialCast(castTo)) {
            return true;
        }
        if (castTo instanceof JInterface) {
            return this.canBeSafelyUpcast((JInterface)castTo);
        }
        return this.isSubTypeOf(castTo);
    }
}

