/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.MethodLoader;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="A Java constructor method")
public class JConstructor
extends JMethod {
    public JConstructor(@Nonnull SourceInfo info, @Nonnull JDefinedClass enclosingType, int modifier) {
        super(info, new JMethodId(new JMethodIdWide("<init>", MethodKind.INSTANCE_NON_VIRTUAL), JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()), enclosingType, modifier);
        assert (JModifier.isMethodModifier(modifier));
        assert (JModifier.isValidMethodModifier(modifier));
        assert (!JModifier.isAbstract(modifier));
        assert (!JModifier.isBridge(modifier));
        assert (!JModifier.isFinal(modifier));
        assert (!JModifier.isNative(modifier));
        assert (!JModifier.isStatic(modifier));
        assert (!JModifier.isSynchronized(modifier));
    }

    public JConstructor(@Nonnull SourceInfo info, @Nonnull JDefinedClass enclosingType, int modifier, @Nonnull MethodLoader loader) {
        super(info, new JMethodId(new JMethodIdWide("<init>", MethodKind.INSTANCE_NON_VIRTUAL), JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()), enclosingType, modifier, loader);
        assert (JModifier.isMethodModifier(modifier));
        assert (JModifier.isValidMethodModifier(modifier));
        assert (!JModifier.isAbstract(modifier));
        assert (!JModifier.isBridge(modifier));
        assert (!JModifier.isFinal(modifier));
        assert (!JModifier.isNative(modifier));
        assert (!JModifier.isStatic(modifier));
        assert (!JModifier.isSynchronized(modifier));
    }

    @Override
    public boolean canBeVirtual() {
        return false;
    }

    @Override
    public JMethodBody getBody() {
        return (JMethodBody)super.getBody();
    }

    @Override
    @Nonnull
    public JDefinedClass getEnclosingType() {
        return (JDefinedClass)super.getEnclosingType();
    }

    public JClass getNewType() {
        return this.getEnclosingType();
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

