/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIntegralConstant32;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.types.JIntegralType;
import com.android.jack.ir.types.JIntegralType32;
import com.android.jack.ir.types.JNumericType;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Conditional expression")
public class JConditionalExpression
extends JExpression {
    @Nonnull
    private JExpression elseExpr;
    @Nonnull
    private JExpression ifTest;
    @Nonnull
    private JExpression thenExpr;

    public JConditionalExpression(@Nonnull SourceInfo info, @Nonnull JExpression ifTest, @Nonnull JExpression thenExpr, @Nonnull JExpression elseExpr) {
        super(info);
        this.ifTest = ifTest;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    @Nonnull
    public JExpression getElseExpr() {
        return this.elseExpr;
    }

    @Nonnull
    public JExpression getIfTest() {
        return this.ifTest;
    }

    @Nonnull
    public JExpression getThenExpr() {
        return this.thenExpr;
    }

    @Override
    @Nonnull
    public JType getType() {
        JType elseType;
        assert (JPrimitiveType.JPrimitiveTypeEnum.BOOLEAN.getType().isEquivalent(this.ifTest.getType()));
        JType thenType = this.thenExpr.getType();
        if (thenType.isSameType(elseType = this.elseExpr.getType())) {
            return thenType;
        }
        if (thenType instanceof JPrimitiveType && ((JPrimitiveType)thenType).isEquivalent(elseType)) {
            return thenType;
        }
        if (elseType instanceof JPrimitiveType && ((JPrimitiveType)elseType).isEquivalent(thenType)) {
            return elseType;
        }
        if (JNullType.isNullType(thenType) && elseType instanceof JReferenceType) {
            return elseType;
        }
        if (JNullType.isNullType(elseType) && thenType instanceof JReferenceType) {
            return thenType;
        }
        JPhantomLookup lookup = Jack.getSession().getPhantomLookup();
        if (this.isNumber(thenType) && this.isNumber(elseType)) {
            if (JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isEquivalent(thenType) && JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isEquivalent(elseType) || JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isEquivalent(elseType) && JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isEquivalent(thenType)) {
                return JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType();
            }
            if ((thenType == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || thenType == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || thenType == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType()) && this.elseExpr instanceof JIntegralConstant32 && elseType instanceof JIntegralType && ((JIntegralType32)((Object)thenType)).isValidValue(((JIntegralConstant32)((Object)this.elseExpr)).getIntValue())) {
                return thenType;
            }
            if ((elseType == JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType() || elseType == JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType() || elseType == JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType()) && this.thenExpr instanceof JIntegralConstant32 && thenType instanceof JIntegralType && ((JIntegralType32)((Object)elseType)).isValidValue(((JIntegralConstant32)((Object)this.thenExpr)).getIntValue())) {
                return elseType;
            }
            if ((JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isWrapperType(thenType) || JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().isWrapperType(thenType) || JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isWrapperType(thenType)) && this.elseExpr instanceof JIntegralConstant32 && elseType instanceof JIntegralType32) {
                JPrimitiveType unboxedThenType = ((JClassOrInterface)thenType).getWrappedType();
                assert (unboxedThenType != null);
                if (((JIntegralType32)((Object)unboxedThenType)).isValidValue(((JIntegralConstant32)((Object)this.elseExpr)).getIntValue())) {
                    return unboxedThenType;
                }
            }
            if ((JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isWrapperType(elseType) || JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().isWrapperType(elseType) || JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isWrapperType(elseType)) && this.thenExpr instanceof JIntegralConstant32 && thenType instanceof JIntegralType32) {
                JPrimitiveType unboxedElseType = ((JClassOrInterface)elseType).getWrappedType();
                assert (unboxedElseType != null);
                if (((JIntegralType32)((Object)unboxedElseType)).isValidValue(((JIntegralConstant32)((Object)this.thenExpr)).getIntValue())) {
                    return unboxedElseType;
                }
            }
            return JPrimitiveType.getBinaryPromotionType(thenType, elseType);
        }
        if (JNullType.isNullType(thenType) && elseType instanceof JPrimitiveType) {
            return ((JPrimitiveType)elseType).getWrapperType();
        }
        if (JNullType.isNullType(elseType) && thenType instanceof JPrimitiveType) {
            return ((JPrimitiveType)thenType).getWrapperType();
        }
        if (thenType instanceof JArrayType && elseType instanceof JArrayType) {
            int elseArrayTypeDims;
            JArrayType thenArrayType = (JArrayType)thenType;
            JArrayType elseArrayType = (JArrayType)elseType;
            int thenArrayTypeDims = thenArrayType.getDims();
            int minDim = thenArrayTypeDims;
            if (minDim > (elseArrayTypeDims = elseArrayType.getDims())) {
                minDim = elseArrayTypeDims;
            }
            if (!(thenArrayType.getLeafType() instanceof JPrimitiveType) && !(elseArrayType.getLeafType() instanceof JPrimitiveType)) {
                return lookup.getArrayType(lookup.getClass(CommonTypes.JAVA_LANG_OBJECT), minDim);
            }
        }
        return lookup.getClass(CommonTypes.JAVA_LANG_OBJECT);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.ifTest);
            visitor.accept(this.thenExpr);
            visitor.accept(this.elseExpr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.ifTest.traverse(schedule);
        this.thenExpr.traverse(schedule);
        this.elseExpr.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.ifTest == existingNode) {
            this.ifTest = (JExpression)newNode;
        } else if (this.thenExpr == existingNode) {
            this.thenExpr = (JExpression)newNode;
        } else if (this.elseExpr == existingNode) {
            this.elseExpr = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    private boolean isNumber(@Nonnull JType type) {
        return type instanceof JNumericType || type instanceof JClassOrInterface && ((JClassOrInterface)type).getWrappedType() instanceof JNumericType;
    }
}

