/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="Composition of JStringLiteral")
public class JCompositeStringLiteral
extends JAbstractStringLiteral {
    @Nonnull
    private JAbstractStringLiteral leftStr;
    @Nonnull
    private JAbstractStringLiteral rightStr;

    public JCompositeStringLiteral(@Nonnull SourceInfo sourceInfo, @Nonnull JAbstractStringLiteral leftStr, JAbstractStringLiteral rightStr) {
        super(sourceInfo);
        this.leftStr = leftStr;
        this.rightStr = rightStr;
    }

    @Override
    @Nonnull
    public String getValue() {
        return this.leftStr.getValue() + this.rightStr.getValue();
    }

    @Override
    @Nonnull
    public JCompositeStringLiteral clone() {
        JCompositeStringLiteral newCompositeString = (JCompositeStringLiteral)super.clone();
        newCompositeString.leftStr = (JAbstractStringLiteral)this.leftStr.clone();
        newCompositeString.rightStr = (JAbstractStringLiteral)this.rightStr.clone();
        return newCompositeString;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.leftStr);
            visitor.accept(this.rightStr);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.leftStr.traverse(schedule);
        this.rightStr.traverse(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        if (this.rightStr == existingNode) {
            this.rightStr = (JAbstractStringLiteral)newNode;
        } else if (this.leftStr == existingNode) {
            this.leftStr = (JAbstractStringLiteral)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }
}

