/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.UnsupportedOperatorException;
import javax.annotation.Nonnull;

public enum JBinaryOperator {
    MUL("*", 3),
    DIV("/", 3),
    MOD("%", 3),
    ADD("+", 4),
    CONCAT("+", 4),
    SUB("-", 4),
    SHL("<<", 5),
    SHR(">>", 5),
    SHRU(">>>", 5),
    LT("<", 6),
    LTE("<=", 6),
    GT(">", 6),
    GTE(">=", 6),
    EQ("==", 7),
    NEQ("!=", 7),
    BIT_AND("&", 8),
    BIT_XOR("^", 9),
    BIT_OR("|", 10),
    AND("&&", 11),
    OR("||", 12),
    ASG("=", 14),
    ASG_ADD("+=", 14, ADD),
    ASG_CONCAT("+=", 14, CONCAT),
    ASG_SUB("-=", 14, SUB),
    ASG_MUL("*=", 14, MUL),
    ASG_DIV("/=", 14, DIV),
    ASG_MOD("%=", 14, MOD),
    ASG_SHL("<<=", 14, SHL),
    ASG_SHR(">>=", 14, SHR),
    ASG_SHRU(">>>=", 14, SHRU),
    ASG_BIT_AND("&=", 14, BIT_AND),
    ASG_BIT_OR("|=", 14, BIT_OR),
    ASG_BIT_XOR("^=", 14, BIT_XOR);

    private final JBinaryOperator nonAsg;
    private final int precedence;
    private final String symbol;

    private JBinaryOperator(String symbol, int precedence) {
        this(symbol, precedence, null);
    }

    private JBinaryOperator(String symbol, int precedence, JBinaryOperator nonAsg) {
        this.symbol = symbol;
        this.precedence = precedence;
        this.nonAsg = nonAsg;
    }

    public JBinaryOperator getNonAssignmentOf() {
        return this.nonAsg;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public boolean isConditionalOperation() {
        return this == AND || this == OR;
    }

    public boolean isLogicalAndBitwiseOperation() {
        return this == BIT_AND || this == BIT_OR || this == BIT_XOR;
    }

    @Nonnull
    public JBinaryOperator getReverseOperator() throws UnsupportedOperatorException {
        switch (this) {
            case BIT_AND: {
                return BIT_OR;
            }
            case BIT_OR: {
                return BIT_AND;
            }
            case BIT_XOR: {
                return EQ;
            }
            case AND: {
                return OR;
            }
            case OR: {
                return AND;
            }
            case LT: {
                return GTE;
            }
            case LTE: {
                return GT;
            }
            case GT: {
                return LTE;
            }
            case GTE: {
                return LT;
            }
            case EQ: {
                return NEQ;
            }
            case NEQ: {
                return EQ;
            }
        }
        throw new UnsupportedOperatorException("Unsupported operator: " + this.toString());
    }

    public boolean isComparison() {
        return this == LT || this == LTE || this == GT || this == GTE || this == EQ || this == NEQ;
    }

    public boolean isAssignment() {
        return this == ASG || this.getNonAssignmentOf() != null;
    }

    public boolean isCompoundAssignment() {
        return this.getNonAssignmentOf() != null;
    }

    public boolean isShiftOperator() {
        return this.precedence == 5 || this.nonAsg != null && this.nonAsg.precedence == 5;
    }

    public String toString() {
        return this.symbol;
    }
}

