/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.JNodeInternalError;
import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="JLiteral representing a fixed array of other JLiteral.")
public class JArrayLiteral
extends JLiteral {
    @Nonnull
    private final List<JLiteral> values;

    public JArrayLiteral(@Nonnull SourceInfo sourceInfo, @Nonnull List<JLiteral> values) {
        super(sourceInfo);
        this.values = values;
    }

    @Override
    @Nonnull
    public JType getType() {
        throw new AssertionError();
    }

    @Nonnull
    public List<JLiteral> getValues() {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(this.values);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            for (JLiteral value : this.values) {
                visitor.accept(value);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        for (JLiteral value : this.values) {
            value.traverse(schedule);
        }
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JArrayLiteral.transform(this.values, existingNode, (JLiteral)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JNameValuePair) && !(this.parent instanceof JAnnotationMethod)) {
            throw new JNodeInternalError(this, "Invalid parent");
        }
    }
}

