/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend;

import com.android.jack.Jack;
import com.android.jack.frontend.VirtualMethodsMarker;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JConstructor;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPhantomClassOrInterface;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.lookup.CommonTypes;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.item.Tag;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Merges ids of JMethods with the same name and arguments in the same hierarchy tree.")
@Transform(add={MethodIdMerged.class, VirtualMethodsMarker.class})
public class MethodIdMerger
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        new Visitor().accept(session.getTypesToEmit());
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final JClass javaLangObject = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_OBJECT);

        private Visitor() {
        }

        @Override
        public boolean visit(@Nonnull JDefinedClass node) {
            if (node.getMarker(VirtualMethodsMarker.class) == null) {
                this.handleDefinedClassOrInterface(node);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JDefinedInterface node) {
            if (node.getMarker(VirtualMethodsMarker.class) == null) {
                this.handleDefinedClassOrInterface(node);
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JPhantomClassOrInterface node) {
            if (node.getMarker(VirtualMethodsMarker.class) == null) {
                this.ensureHierarchyVisited(node);
            }
            return false;
        }

        private void ensureHierarchyVisited(@Nonnull JClassOrInterface node) {
            JClass zuper = this.getSuper(node);
            if (zuper != null) {
                this.accept(zuper);
            }
            if (node instanceof JDefinedClassOrInterface) {
                for (JClassOrInterface jClassOrInterface : ((JDefinedClassOrInterface)node).getImplements()) {
                    this.accept(jClassOrInterface);
                }
            }
        }

        private void handleDefinedClassOrInterface(@Nonnull JDefinedClassOrInterface node) {
            VirtualMethodsMarker virtualMethods;
            this.ensureHierarchyVisited(node);
            JClass zuper = this.getSuper(node);
            while (zuper instanceof JPhantomClassOrInterface) {
                zuper = this.getSuper(zuper);
            }
            if (zuper != null) {
                VirtualMethodsMarker superMarker = ((JNode)((Object)zuper)).getMarker(VirtualMethodsMarker.class);
                assert (superMarker != null);
                virtualMethods = superMarker.clone();
            } else {
                virtualMethods = new VirtualMethodsMarker();
            }
            for (JInterface interfaze : node.getImplements()) {
                if (!(interfaze instanceof JDefinedClassOrInterface)) continue;
                this.addIds(virtualMethods, (JNode)((Object)interfaze));
            }
            for (JMethod method : node.getMethods()) {
                if (method.isStatic() || method.isPrivate() || method instanceof JConstructor) continue;
                this.addId(virtualMethods, method.getMethodIdWide());
            }
            node.addMarker(virtualMethods);
        }

        private void addIds(@Nonnull VirtualMethodsMarker mergeInto, @Nonnull JNode toMerge) {
            VirtualMethodsMarker methodsToMerge = toMerge.getMarker(VirtualMethodsMarker.class);
            assert (methodsToMerge != null);
            for (JMethodIdWide jMethodId : methodsToMerge) {
                this.addId(mergeInto, jMethodId);
            }
        }

        private void addId(@Nonnull VirtualMethodsMarker virtualMethods, @Nonnull JMethodIdWide toAdd) {
            JMethodIdWide existingMethod = virtualMethods.get(toAdd);
            if (existingMethod != null) {
                this.mergeId(existingMethod, toAdd);
            } else {
                virtualMethods.add(toAdd);
            }
        }

        private void mergeId(@Nonnull JMethodIdWide keep, @Nonnull JMethodIdWide duplicate) {
            if ((keep = this.getKeptId(keep)) == (duplicate = this.getKeptId(duplicate))) {
                return;
            }
            for (JMethodId duplicateId : duplicate.getMethodIds()) {
                JMethodId keptId = keep.getMethodId(duplicateId.getType());
                if (keptId == null) {
                    keptId = new JMethodId(keep, duplicateId.getType());
                }
                for (JMethod method : duplicateId.getMethods()) {
                    method.setMethodId(keptId);
                }
            }
        }

        @Nonnull
        private JMethodIdWide getKeptId(@Nonnull JMethodIdWide possiblyDroppedId) {
            Iterator<JMethod> methods1 = possiblyDroppedId.getMethods().iterator();
            assert (methods1.hasNext()) : "Only method id contained in JMethod are considered by this visitor";
            return methods1.next().getMethodIdWide();
        }

        @CheckForNull
        private JClass getSuper(@Nonnull JClassOrInterface node) {
            if (node instanceof JDefinedClass) {
                return ((JDefinedClass)node).getSuperClass();
            }
            if (!node.isSameType(this.javaLangObject)) {
                return this.javaLangObject;
            }
            return null;
        }
    }

    @Description(value="JMethodId were merged")
    @Name(value="MethodIdMerged")
    public static class MethodIdMerged
    implements Tag {
    }
}

