/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.ext.beans;

import com.android.jack.freemarker.ext.beans.BeansWrapper;
import com.android.jack.freemarker.ext.beans.OverloadedMethods;
import com.android.jack.freemarker.ext.beans.OverloadedMethodsModel;
import com.android.jack.freemarker.ext.beans.SimpleMethodModel;
import com.android.jack.freemarker.log.Logger;
import com.android.jack.freemarker.template.TemplateCollectionModel;
import com.android.jack.freemarker.template.TemplateHashModelEx;
import com.android.jack.freemarker.template.TemplateModel;
import com.android.jack.freemarker.template.TemplateModelException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

final class StaticModel
implements TemplateHashModelEx {
    private static final Logger LOG = Logger.getLogger("com.android.jack.freemarker.beans");
    private final Class clazz;
    private final BeansWrapper wrapper;
    private final Map map = new HashMap();

    StaticModel(Class clazz, BeansWrapper wrapper) throws TemplateModelException {
        this.clazz = clazz;
        this.wrapper = wrapper;
        this.populate();
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object model = this.map.get(key);
        if (model instanceof TemplateModel) {
            return (TemplateModel)model;
        }
        if (model instanceof Field) {
            try {
                return this.wrapper.getOuterIdentity().wrap(((Field)model).get(null));
            }
            catch (IllegalAccessException e) {
                throw new TemplateModelException("Illegal access for field " + key + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + key + " in class " + this.clazz.getName());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.keySet());
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.getOuterIdentity().wrap(this.map.values());
    }

    private void populate() throws TemplateModelException {
        if (!Modifier.isPublic(this.clazz.getModifiers())) {
            throw new TemplateModelException("Can't wrap the non-public class " + this.clazz.getName());
        }
        if (this.wrapper.getExposureLevel() == 3) {
            return;
        }
        Field[] fields = this.clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
            if (Modifier.isFinal(n)) {
                try {
                    this.map.put(field.getName(), this.wrapper.getOuterIdentity().wrap(field.get(null)));
                }
                catch (IllegalAccessException illegalAccessException) {}
                continue;
            }
            this.map.put(field.getName(), field);
        }
        if (this.wrapper.getExposureLevel() < 2) {
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                OverloadedMethods overloadedMethods;
                Method method = methods[i];
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !this.wrapper.getClassIntrospector().isAllowedToExpose(method)) continue;
                String name = method.getName();
                Object obj = this.map.get(name);
                if (obj instanceof Method) {
                    overloadedMethods = new OverloadedMethods(this.wrapper.is2321Bugfixed());
                    overloadedMethods.addMethod((Method)obj);
                    overloadedMethods.addMethod(method);
                    this.map.put(name, overloadedMethods);
                    continue;
                }
                if (obj instanceof OverloadedMethods) {
                    overloadedMethods = (OverloadedMethods)obj;
                    overloadedMethods.addMethod(method);
                    continue;
                }
                if (obj != null && LOG.isInfoEnabled()) {
                    LOG.info("Overwriting value [" + obj + "] for " + " key '" + name + "' with [" + method + "] in static model for " + this.clazz.getName());
                }
                this.map.put(name, method);
            }
            for (Map.Entry entry : this.map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Method) {
                    Method method = (Method)value;
                    entry.setValue(new SimpleMethodModel(null, method, method.getParameterTypes(), this.wrapper));
                    continue;
                }
                if (!(value instanceof OverloadedMethods)) continue;
                entry.setValue(new OverloadedMethodsModel(null, (OverloadedMethods)value, this.wrapper));
            }
        }
    }
}

