/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.ListLiteral;
import com.android.jack.freemarker.core.NonNodeException;
import com.android.jack.freemarker.core.NonSequenceException;
import com.android.jack.freemarker.core.ParameterRole;
import com.android.jack.freemarker.core.StringLiteral;
import com.android.jack.freemarker.core.TemplateElement;
import com.android.jack.freemarker.core._MiscTemplateException;
import com.android.jack.freemarker.template.SimpleSequence;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.TemplateHashModel;
import com.android.jack.freemarker.template.TemplateModel;
import com.android.jack.freemarker.template.TemplateNodeModel;
import com.android.jack.freemarker.template.TemplateScalarModel;
import com.android.jack.freemarker.template.TemplateSequenceModel;
import java.io.IOException;

final class RecurseNode
extends TemplateElement {
    Expression targetNode;
    Expression namespaces;

    RecurseNode(Expression targetNode, Expression namespaces) {
        this.targetNode = targetNode;
        this.namespaces = namespaces;
    }

    TemplateElement[] accept(Environment env) throws IOException, TemplateException {
        TemplateModel nss;
        TemplateModel node;
        TemplateModel templateModel = node = this.targetNode == null ? null : this.targetNode.eval(env);
        if (node != null && !(node instanceof TemplateNodeModel)) {
            throw new NonNodeException(this.targetNode, node, "node", env);
        }
        TemplateModel templateModel2 = nss = this.namespaces == null ? null : this.namespaces.eval(env);
        if (this.namespaces instanceof StringLiteral) {
            nss = env.importLib(((TemplateScalarModel)nss).getAsString(), null);
        } else if (this.namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)this.namespaces).evaluateStringsToNamespaces(env);
        }
        if (nss != null) {
            if (nss instanceof TemplateHashModel) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(nss);
                nss = ss;
            } else if (!(nss instanceof TemplateSequenceModel)) {
                if (this.namespaces != null) {
                    throw new NonSequenceException(this.namespaces, nss, env);
                }
                throw new _MiscTemplateException(env, "Expecting a sequence of namespaces after \"using\"");
            }
        }
        env.recurse((TemplateNodeModel)node, (TemplateSequenceModel)nss);
        return null;
    }

    protected String dump(boolean canonical) {
        StringBuilder sb = new StringBuilder();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (this.targetNode != null) {
            sb.append(' ');
            sb.append(this.targetNode.getCanonicalForm());
        }
        if (this.namespaces != null) {
            sb.append(" using ");
            sb.append(this.namespaces.getCanonicalForm());
        }
        if (canonical) {
            sb.append("/>");
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return "#recurse";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.targetNode;
            }
            case 1: {
                return this.namespaces;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.NODE;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }

    boolean isShownInStackTrace() {
        return true;
    }
}

