/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.Identifier;
import com.android.jack.freemarker.core.NonHashException;
import com.android.jack.freemarker.core.ParameterRole;
import com.android.jack.freemarker.core._CoreStringUtils;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.TemplateHashModel;
import com.android.jack.freemarker.template.TemplateModel;

final class Dot
extends Expression {
    private final Expression target;
    private final String key;

    Dot(Expression target, String key) {
        this.target = target;
        this.key = key;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        TemplateModel leftModel = this.target.eval(env);
        if (leftModel instanceof TemplateHashModel) {
            return ((TemplateHashModel)leftModel).get(this.key);
        }
        if (leftModel == null && env.isClassicCompatible()) {
            return null;
        }
        throw new NonHashException(this.target, leftModel, env);
    }

    public String getCanonicalForm() {
        return this.target.getCanonicalForm() + this.getNodeTypeSymbol() + _CoreStringUtils.toFTLIdentifierReferenceAfterDot(this.key);
    }

    String getNodeTypeSymbol() {
        return ".";
    }

    boolean isLiteral() {
        return this.target.isLiteral();
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new Dot(this.target.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.key);
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        return idx == 0 ? this.target : this.key;
    }

    ParameterRole getParameterRole(int idx) {
        return ParameterRole.forBinaryOperatorOperand(idx);
    }

    String getRHO() {
        return this.key;
    }

    boolean onlyHasIdentifiers() {
        return this.target instanceof Identifier || this.target instanceof Dot && ((Dot)this.target).onlyHasIdentifiers();
    }
}

