/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ecj.loader.jast;

import com.android.jack.ecj.loader.jast.AnnotationUtils;
import com.android.jack.eclipse.jdt.internal.compiler.env.IBinaryType;
import com.android.jack.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.ByteConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.CharConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.Constant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.FloatConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.IntConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.LongConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.ShortConstant;
import com.android.jack.eclipse.jdt.internal.compiler.impl.StringConstant;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JByteLiteral;
import com.android.jack.ir.ast.JCharLiteral;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDoubleLiteral;
import com.android.jack.ir.ast.JEnumLiteral;
import com.android.jack.ir.ast.JFloatLiteral;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JLongLiteral;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JShortLiteral;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.sched.marker.LocalMarkerManager;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class LoaderUtils {
    @Nonnull
    private static final TypeAndMethodFormatter signatureFormatter = BinarySignatureFormatter.getFormatter();
    @Nonnull
    private static final TypeFormatter qualifiedNameFormatter = BinaryQualifiedNameFormatter.getFormatter();
    private static final int MODIFIER_MASK = -65537;

    LoaderUtils() {
    }

    static int convertJAstModifiersToEcj(int accessFlags, @CheckForNull Annotable annotable) {
        int filtered = accessFlags & 0xFFFEFFFF;
        if (annotable != null && AnnotationUtils.getAnnotation(annotable, "Ljava/lang/Deprecated;") != null || JModifier.isDeprecated(filtered)) {
            filtered |= 0x100000;
        }
        return filtered;
    }

    static boolean isDeprecated(@Nonnull IBinaryType enclosing) {
        return (enclosing.getTagBits() & 0x400000000000L) != 0L || (enclosing.getModifiers() & 0x100000) != 0;
    }

    @Nonnull
    static Constant convertJLiteralToEcj(@CheckForNull JLiteral literal) {
        Constant constant = Constant.NotAConstant;
        if (!(literal == null || literal instanceof JAnnotation || literal instanceof JArrayLiteral || literal instanceof JEnumLiteral || literal instanceof JMethodLiteral || literal instanceof JClassLiteral)) {
            if (literal instanceof JBooleanLiteral) {
                constant = BooleanConstant.fromValue(((JBooleanLiteral)literal).getValue());
            } else if (literal instanceof JByteLiteral) {
                constant = ByteConstant.fromValue(((JByteLiteral)literal).getValue());
            } else if (literal instanceof JCharLiteral) {
                constant = CharConstant.fromValue(((JCharLiteral)literal).getValue());
            } else if (literal instanceof JShortLiteral) {
                constant = ShortConstant.fromValue(((JShortLiteral)literal).getValue());
            } else if (literal instanceof JIntLiteral) {
                constant = IntConstant.fromValue(((JIntLiteral)literal).getValue());
            } else if (literal instanceof JFloatLiteral) {
                constant = FloatConstant.fromValue(((JFloatLiteral)literal).getValue());
            } else if (literal instanceof JLongLiteral) {
                constant = LongConstant.fromValue(((JLongLiteral)literal).getValue());
            } else if (literal instanceof JDoubleLiteral) {
                constant = DoubleConstant.fromValue(((JDoubleLiteral)literal).getValue());
            } else if (literal instanceof JAbstractStringLiteral) {
                constant = StringConstant.fromValue(((JAbstractStringLiteral)literal).getValue());
            } else {
                if (literal instanceof JNullLiteral) {
                    throw new AssertionError();
                }
                throw new AssertionError();
            }
        }
        return constant;
    }

    @CheckForNull
    static <T extends JNode> char[] getGenericSignature(@Nonnull T annotableNode) {
        GenericSignature typeInfo = ((LocalMarkerManager)annotableNode).getMarker(GenericSignature.class);
        if (typeInfo != null) {
            return typeInfo.getGenericSignature().toCharArray();
        }
        JAnnotation signatureAnnotation = AnnotationUtils.getAnnotation((Annotable)annotableNode, "Ldalvik/annotation/Signature;");
        if (signatureAnnotation != null) {
            JNameValuePair pair = signatureAnnotation.getNameValuePair("value");
            assert (pair != null);
            String genericSignature = LoaderUtils.concatenate((JArrayLiteral)pair.getValue());
            return genericSignature.toCharArray();
        }
        return null;
    }

    @Nonnull
    private static String concatenate(@Nonnull JArrayLiteral valueArray) {
        StringBuilder builder = new StringBuilder();
        for (JLiteral value : valueArray.getValues()) {
            builder.append(((JAbstractStringLiteral)value).getValue());
        }
        return builder.toString();
    }

    @Nonnull
    static TypeAndMethodFormatter getSignatureFormatter() {
        return signatureFormatter;
    }

    @Nonnull
    static TypeFormatter getQualifiedNameFormatter() {
        return qualifiedNameFormatter;
    }
}

