/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.ssa.back;

import com.android.jack.dx.rop.code.BasicBlock;
import com.android.jack.dx.rop.code.BasicBlockList;
import com.android.jack.dx.rop.code.InsnList;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.Rop;
import com.android.jack.dx.rop.code.RopMethod;
import com.android.jack.dx.rop.code.Rops;
import com.android.jack.dx.ssa.BasicRegisterMapper;
import com.android.jack.dx.ssa.PhiInsn;
import com.android.jack.dx.ssa.RegisterMapper;
import com.android.jack.dx.ssa.SsaBasicBlock;
import com.android.jack.dx.ssa.SsaInsn;
import com.android.jack.dx.ssa.SsaMethod;
import com.android.jack.dx.ssa.back.FirstFitLocalCombiningAllocator;
import com.android.jack.dx.ssa.back.IdenticalBlockCombiner;
import com.android.jack.dx.ssa.back.InterferenceGraph;
import com.android.jack.dx.ssa.back.LivenessAnalyzer;
import com.android.jack.dx.ssa.back.RedundantConditionalBranchRemover;
import com.android.jack.dx.ssa.back.RegisterAllocator;
import com.android.jack.dx.util.Hex;
import com.android.jack.dx.util.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;

public class SsaToRop {
    private static final boolean DEBUG = false;
    private final boolean removeRedundantConditionalBranch;
    private final SsaMethod ssaMeth;
    private final InterferenceGraph interference;

    public static RopMethod convertToRopMethod(SsaMethod ssaMeth, boolean removeRedundantConditionalBranch) {
        return new SsaToRop(ssaMeth, removeRedundantConditionalBranch).convert();
    }

    private SsaToRop(SsaMethod ssaMethod, boolean removeRedundantConditionalBranch) {
        this.ssaMeth = ssaMethod;
        this.removeRedundantConditionalBranch = removeRedundantConditionalBranch;
        this.interference = LivenessAnalyzer.constructInterferenceGraph(ssaMethod);
    }

    private RopMethod convert() {
        FirstFitLocalCombiningAllocator allocator = new FirstFitLocalCombiningAllocator(this.ssaMeth, this.interference);
        RegisterMapper mapper = ((RegisterAllocator)allocator).allocateRegisters();
        this.ssaMeth.setBackMode();
        this.ssaMeth.mapRegisters(mapper);
        this.removePhiFunctions();
        if (((RegisterAllocator)allocator).wantsParamsMovedHigh()) {
            this.moveParametersToHighRegisters();
        }
        if (this.removeRedundantConditionalBranch) {
            new RedundantConditionalBranchRemover(this.ssaMeth).process();
        }
        this.removeEmptyGotos();
        RopMethod ropMethod = new RopMethod(this.convertBasicBlocks(), this.ssaMeth.blockIndexToRopLabel(this.ssaMeth.getEntryBlockIndex()));
        ropMethod = new IdenticalBlockCombiner(ropMethod).process();
        return ropMethod;
    }

    private void removeEmptyGotos() {
        final ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        this.ssaMeth.forEachBlockDepthFirst(false, new SsaBasicBlock.Visitor(){

            @Override
            public void visitBlock(SsaBasicBlock b, SsaBasicBlock parent) {
                if (b.isSingleGoto()) {
                    BitSet preds = (BitSet)b.getPredecessors().clone();
                    int i = preds.nextSetBit(0);
                    while (i >= 0) {
                        SsaBasicBlock pb = (SsaBasicBlock)blocks.get(i);
                        pb.replaceSuccessor(b.getIndex(), b.getPrimarySuccessorIndex());
                        i = preds.nextSetBit(i + 1);
                    }
                }
            }
        });
    }

    private void removePhiFunctions() {
        ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        for (SsaBasicBlock block : blocks) {
            block.forEachPhiInsn(new PhiVisitor(blocks));
            block.removeAllPhiInsns();
        }
        for (SsaBasicBlock block : blocks) {
            block.scheduleMovesFromPhis();
        }
    }

    private void moveParametersToHighRegisters() {
        int paramWidth = this.ssaMeth.getParamWidth();
        BasicRegisterMapper mapper = new BasicRegisterMapper(this.ssaMeth.getRegCount());
        int regCount = this.ssaMeth.getRegCount();
        for (int i = 0; i < regCount; ++i) {
            if (i < paramWidth) {
                mapper.addMapping(i, regCount - paramWidth + i, 1);
                continue;
            }
            mapper.addMapping(i, i - paramWidth, 1);
        }
        this.ssaMeth.mapRegisters(mapper);
    }

    private BasicBlockList convertBasicBlocks() {
        ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        SsaBasicBlock exitBlock = this.ssaMeth.getExitBlock();
        this.ssaMeth.computeReachability();
        int ropBlockCount = this.ssaMeth.getCountReachableBlocks();
        BasicBlockList result = new BasicBlockList(ropBlockCount -= exitBlock != null && exitBlock.isReachable() ? 1 : 0);
        int ropBlockIndex = 0;
        for (SsaBasicBlock b : blocks) {
            if (!b.isReachable() || b == exitBlock) continue;
            result.set(ropBlockIndex++, this.convertBasicBlock(b));
        }
        if (exitBlock != null && exitBlock.getInsns().size() != 0) {
            throw new RuntimeException("Exit block must have no insns when leaving SSA form");
        }
        return result;
    }

    private void verifyValidExitPredecessor(SsaBasicBlock b) {
        List<SsaInsn> insns = b.getInsns();
        SsaInsn lastInsn = insns.get(insns.size() - 1);
        Rop opcode = lastInsn.getOpcode();
        if (opcode.getBranchingness() != 2 && opcode != Rops.THROW) {
            throw new RuntimeException("Exit predecessor must end in valid exit statement.");
        }
    }

    private BasicBlock convertBasicBlock(SsaBasicBlock block) {
        int exitRopLabel;
        IntList successorList = block.getRopLabelSuccessorList();
        int primarySuccessorLabel = block.getPrimarySuccessorRopLabel();
        SsaBasicBlock exitBlock = this.ssaMeth.getExitBlock();
        int n = exitRopLabel = exitBlock == null ? -1 : exitBlock.getRopLabel();
        if (successorList.contains(exitRopLabel)) {
            if (successorList.size() > 1) {
                throw new RuntimeException("Exit predecessor must have no other successors" + Hex.u2(block.getRopLabel()));
            }
            successorList = IntList.EMPTY;
            primarySuccessorLabel = -1;
            this.verifyValidExitPredecessor(block);
        }
        successorList.setImmutable();
        BasicBlock result = new BasicBlock(block.getRopLabel(), this.convertInsns(block.getInsns()), successorList, primarySuccessorLabel);
        return result;
    }

    private InsnList convertInsns(List<SsaInsn> ssaInsns) {
        int insnCount = ssaInsns.size();
        InsnList result = new InsnList(insnCount);
        for (int i = 0; i < insnCount; ++i) {
            result.set(i, ssaInsns.get(i).toRopInsn());
        }
        result.setImmutable();
        return result;
    }

    public int[] getRegistersByFrequency() {
        int regCount = this.ssaMeth.getRegCount();
        Integer[] ret = new Integer[regCount];
        for (int i = 0; i < regCount; ++i) {
            ret[i] = i;
        }
        Arrays.sort(ret, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return SsaToRop.this.ssaMeth.getUseListForRegister(o2).size() - SsaToRop.this.ssaMeth.getUseListForRegister(o1).size();
            }
        });
        int[] result = new int[regCount];
        for (int i = 0; i < regCount; ++i) {
            result[i] = ret[i];
        }
        return result;
    }

    private static class PhiVisitor
    implements PhiInsn.Visitor {
        private final ArrayList<SsaBasicBlock> blocks;

        public PhiVisitor(ArrayList<SsaBasicBlock> blocks) {
            this.blocks = blocks;
        }

        @Override
        public void visitPhiInsn(PhiInsn insn) {
            RegisterSpecList sources = insn.getSources();
            RegisterSpec result = insn.getResult();
            int sz = sources.size();
            for (int i = 0; i < sz; ++i) {
                RegisterSpec source = sources.get(i);
                SsaBasicBlock predBlock = this.blocks.get(insn.predBlockIndexForSourcesIndex(i));
                predBlock.addMoveToEnd(result, source);
            }
        }
    }
}

