/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.code;

import com.android.jack.dx.rop.code.Insn;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.Rop;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.Constant;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class DualCstInsn
extends Insn {
    @Nonnull
    private final Constant firstConstant;
    @Nonnull
    private final Constant secondConstant;

    public DualCstInsn(@Nonnull Rop opcode, @Nonnull SourcePosition position, @CheckForNull RegisterSpec result, @Nonnull RegisterSpecList sources, @Nonnull Constant firstConstant, @Nonnull Constant secondConstant) {
        super(opcode, position, result, sources);
        assert (firstConstant != null);
        assert (secondConstant != null);
        this.firstConstant = firstConstant;
        this.secondConstant = secondConstant;
    }

    @Override
    @Nonnull
    public String getInlineString() {
        return this.firstConstant.toHuman() + ", " + this.secondConstant.toHuman();
    }

    @Nonnull
    public Constant getFirstConstant() {
        return this.firstConstant;
    }

    @Nonnull
    public Constant getSecondConstant() {
        return this.secondConstant;
    }

    @Override
    public boolean contentEquals(Insn b) {
        return super.contentEquals(b) && this.firstConstant.equals(((DualCstInsn)b).getFirstConstant()) && this.secondConstant.equals(((DualCstInsn)b).getSecondConstant());
    }
}

