/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io.instructions;

import com.android.jack.dx.io.IndexType;
import com.android.jack.dx.io.OpcodeInfo;
import com.android.jack.dx.io.instructions.DecodedInstruction;
import com.android.jack.dx.io.instructions.InstructionCodec;

public final class TwoRegisterDecodedInstruction
extends DecodedInstruction {
    private final int a;
    private final int b;

    public TwoRegisterDecodedInstruction(InstructionCodec format, int opcode, int firstIndex, IndexType firstIndexType, int target, long literal, int a, int b) {
        this(format, opcode, firstIndex, firstIndexType, target, literal, a, b, 0, IndexType.NONE);
        assert (!OpcodeInfo.hasDualConstants(opcode));
    }

    public TwoRegisterDecodedInstruction(InstructionCodec format, int opcode, int firstIndex, IndexType firstIndexType, int target, long literal, int a, int b, int secondIndex, IndexType secondIndexType) {
        super(format, opcode, firstIndex, firstIndexType, target, literal, secondIndex, secondIndexType);
        this.a = a;
        this.b = b;
    }

    @Override
    public int getRegisterCount() {
        return 2;
    }

    @Override
    public int getA() {
        return this.a;
    }

    @Override
    public int getB() {
        return this.b;
    }

    @Override
    public DecodedInstruction withIndex(int newFirstIndex, int newSecondIndex) {
        return new TwoRegisterDecodedInstruction(this.getFormat(), this.getOpcode(), newFirstIndex, this.getFirstIndexType(), this.getTarget(), this.getLiteral(), this.a, this.b, newSecondIndex, this.getSecondIndexType());
    }
}

