/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.util.ByteInput;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class EncodedValueCodec {
    private EncodedValueCodec() {
    }

    public static int readSignedInt(@Nonnull ByteInput in, @Nonnegative int zwidth) {
        int result = 0;
        for (int i = zwidth; i >= 0; --i) {
            result = result >>> 8 | (in.readByte() & 0xFF) << 24;
        }
        return result >>= (3 - zwidth) * 8;
    }

    public static int readUnsignedInt(@Nonnull ByteInput in, @Nonnegative int zwidth, boolean fillOnRight) {
        int result = 0;
        if (!fillOnRight) {
            for (int i = zwidth; i >= 0; --i) {
                result = result >>> 8 | (in.readByte() & 0xFF) << 24;
            }
            result >>>= (3 - zwidth) * 8;
        } else {
            for (int i = zwidth; i >= 0; --i) {
                result = result >>> 8 | (in.readByte() & 0xFF) << 24;
            }
        }
        return result;
    }

    public static long readSignedLong(@Nonnull ByteInput in, @Nonnegative int zwidth) {
        long result = 0L;
        for (int i = zwidth; i >= 0; --i) {
            result = result >>> 8 | ((long)in.readByte() & 0xFFL) << 56;
        }
        return result >>= (7 - zwidth) * 8;
    }

    public static long readUnsignedLong(@Nonnull ByteInput in, @Nonnegative int zwidth, boolean fillOnRight) {
        long result = 0L;
        if (!fillOnRight) {
            for (int i = zwidth; i >= 0; --i) {
                result = result >>> 8 | ((long)in.readByte() & 0xFFL) << 56;
            }
            result >>>= (7 - zwidth) * 8;
        } else {
            for (int i = zwidth; i >= 0; --i) {
                result = result >>> 8 | ((long)in.readByte() & 0xFFL) << 56;
            }
        }
        return result;
    }
}

