/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.Code;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.ImportedDebugInfoItem;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.OffsettedItem;
import com.android.jack.dx.dex.file.Section;
import com.android.jack.dx.io.Code;
import com.android.jack.dx.io.CodeReader;
import com.android.jack.dx.io.instructions.DecodedInstruction;
import com.android.jack.dx.io.instructions.ShortArrayCodeOutput;
import com.android.jack.dx.rop.cst.CstIndexMap;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.ByteArrayAnnotatedOutput;
import com.android.jack.dx.util.DexException;
import com.android.jack.dx.util.Hex;
import java.io.PrintWriter;

public final class ImportedCodeItem
extends OffsettedItem
implements Code {
    ImportedDebugInfoItem debugInfoItem = null;
    private final CstMethodRef ref;
    private final com.android.jack.dx.io.Code code;
    private final CstIndexMap cstIndexMap;
    private DecodedInstruction[] remappedInstructions;
    private int remappingIndex;
    private byte[] encodedHandlers;
    private int[] remappedCatchHandlerOffsets;

    public ImportedCodeItem(CstMethodRef ref, com.android.jack.dx.io.Code code, ImportedDebugInfoItem debugInfoItem, CstIndexMap cstIndexMap) {
        super(4, -1);
        if (ref == null) {
            throw new NullPointerException("ref == null");
        }
        this.ref = ref;
        if (code == null) {
            throw new NullPointerException("code == null");
        }
        this.code = code;
        this.debugInfoItem = debugInfoItem;
        if (cstIndexMap == null) {
            throw new NullPointerException("cstIndexMap == null");
        }
        this.cstIndexMap = cstIndexMap;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_CODE_ITEM;
    }

    @Override
    public void addContents(DexFile file) {
        if (this.debugInfoItem != null) {
            file.getByteData().add(this.debugInfoItem);
        }
    }

    public String toString() {
        return "CodeItem{" + this.toHuman() + "}";
    }

    @Override
    public String toHuman() {
        return this.ref.toHuman();
    }

    public CstMethodRef getRef() {
        return this.ref;
    }

    @Override
    protected void place0(Section addedTo, int offset) {
        int triesLength = this.code.getTries().length;
        this.encodedHandlers = triesLength != 0 ? this.encodeAndRemapCatchHandler(addedTo.getFile()) : new byte[]{};
        int catchesSize = triesLength * 8 + this.encodedHandlers.length;
        int insnsSize = this.code.getInstructions().length;
        if ((insnsSize & 1) != 0) {
            ++insnsSize;
        }
        this.setWriteSize(16 + insnsSize * 2 + catchesSize);
    }

    @Override
    protected void writeTo0(DexFile file, AnnotatedOutput out) {
        boolean annotates = out.annotates();
        int regSz = this.getRegistersSize();
        int outsSz = this.getOutsSize();
        int insSz = this.getInsSize();
        int insnsSz = this.code.getInstructions().length;
        boolean needPadding = (insnsSz & 1) != 0;
        int debugOff = this.debugInfoItem == null ? 0 : this.debugInfoItem.getAbsoluteOffset();
        int triesSz = this.code.getTries().length;
        if (annotates) {
            out.annotate(0, this.offsetString() + ' ' + this.ref.toHuman());
            out.annotate(2, "  registers_size: " + Hex.u2(regSz));
            out.annotate(2, "  ins_size:       " + Hex.u2(insSz));
            out.annotate(2, "  outs_size:      " + Hex.u2(outsSz));
            out.annotate(2, "  tries_size:     " + Hex.u2(triesSz));
            out.annotate(4, "  debug_off:      " + Hex.u4(debugOff));
            out.annotate(4, "  insns_size:     " + Hex.u4(insnsSz));
        }
        out.writeShort(regSz);
        out.writeShort(insSz);
        out.writeShort(outsSz);
        out.writeShort(triesSz);
        out.writeInt(debugOff);
        out.writeInt(insnsSz);
        for (short inst : this.encodeAndRemapCode(file, this.code.getInstructions())) {
            out.writeShort(inst);
        }
        if (triesSz != 0) {
            if (needPadding) {
                if (annotates) {
                    out.annotate(2, "  padding: 0");
                }
                out.writeShort(0);
            }
            for (Code.Try atry : this.code.getTries()) {
                out.writeInt(atry.getStartAddress());
                out.writeShort(atry.getInstructionCount());
                out.writeShort(this.remappedCatchHandlerOffsets[atry.getCatchHandlerIndex()]);
            }
            out.write(this.encodedHandlers);
        }
        if (annotates && this.debugInfoItem != null) {
            out.annotate(0, "  debug info");
            this.debugInfoItem.annotateTo(file, out, "    ");
        }
    }

    private byte[] encodeAndRemapCatchHandler(DexFile file) {
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
        Code.CatchHandler[] catchHandlers = this.code.getCatchHandlers();
        out.writeUleb128(catchHandlers.length);
        this.remappedCatchHandlerOffsets = new int[catchHandlers.length];
        int catchHandlerIdx = 0;
        for (Code.CatchHandler catchHandler : catchHandlers) {
            this.remappedCatchHandlerOffsets[catchHandlerIdx++] = out.getCursor();
            int catchAllAddress = catchHandler.getCatchAllAddress();
            int[] typeIndexes = catchHandler.getTypeIndexes();
            int[] addresses = catchHandler.getAddresses();
            if (catchAllAddress != -1) {
                out.writeSleb128(-typeIndexes.length);
            } else {
                out.writeSleb128(typeIndexes.length);
            }
            for (int i = 0; i < typeIndexes.length; ++i) {
                out.writeUleb128(this.cstIndexMap.getRemappedCstTypeIndex(file, typeIndexes[i]));
                out.writeUleb128(addresses[i]);
            }
            if (catchAllAddress == -1) continue;
            out.writeUleb128(catchAllAddress);
        }
        return out.toByteArray();
    }

    private short[] encodeAndRemapCode(DexFile file, short[] insts) {
        CodeReader codeReader = new CodeReader();
        DecodedInstruction[] decodedInstructions = DecodedInstruction.decodeAll(insts);
        this.remappedInstructions = new DecodedInstruction[decodedInstructions.length];
        this.remappingIndex = 0;
        codeReader.setFallbackVisitor(new GenericVisitor());
        codeReader.setStringVisitor(new StringRemapper(file));
        codeReader.setFieldVisitor(new FieldRemapper(file));
        codeReader.setTypeVisitor(new TypeRemapper(file));
        codeReader.setMethodVisitor(new MethodRemapper(file));
        codeReader.setDualConstantVisitor(new DualConstantRemapper(file));
        codeReader.visitAll(decodedInstructions);
        ShortArrayCodeOutput outputCode = new ShortArrayCodeOutput(insts.length);
        for (DecodedInstruction instruction : this.remappedInstructions) {
            if (instruction == null) continue;
            instruction.encode(outputCode);
        }
        return outputCode.getArray();
    }

    private int getInsSize() {
        return this.code.getInsSize();
    }

    private int getOutsSize() {
        return this.code.getOutsSize();
    }

    private int getRegistersSize() {
        return this.code.getRegistersSize();
    }

    @Override
    public void debugPrint(PrintWriter out, String prefix, boolean verbose) {
        throw new AssertionError((Object)"Not yet supported");
    }

    public CstIndexMap getCstIndexMap() {
        return this.cstIndexMap;
    }

    private class DualConstantRemapper
    implements CodeReader.Visitor {
        private final DexFile file;

        public DualConstantRemapper(DexFile dex) {
            this.file = dex;
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst.withIndex(ImportedCodeItem.this.cstIndexMap.getRemappedCstBaseMethodRefIndex(this.file, decodedInst.getFirstIndex()), ImportedCodeItem.this.cstIndexMap.getRemappedCstPrototypeRefIndex(this.file, decodedInst.getSecondIndex()));
        }
    }

    private class MethodRemapper
    implements CodeReader.Visitor {
        private final DexFile file;

        public MethodRemapper(DexFile dex) {
            this.file = dex;
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst.withIndex(ImportedCodeItem.this.cstIndexMap.getRemappedCstBaseMethodRefIndex(this.file, decodedInst.getFirstIndex()));
        }
    }

    private class TypeRemapper
    implements CodeReader.Visitor {
        private final DexFile file;

        public TypeRemapper(DexFile dex) {
            this.file = dex;
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst.withIndex(ImportedCodeItem.this.cstIndexMap.getRemappedCstTypeIndex(this.file, decodedInst.getFirstIndex()));
        }
    }

    private class FieldRemapper
    implements CodeReader.Visitor {
        private final DexFile file;

        public FieldRemapper(DexFile dex) {
            this.file = dex;
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst.withIndex(ImportedCodeItem.this.cstIndexMap.getRemappedCstFieldRefIndex(this.file, decodedInst.getFirstIndex()));
        }
    }

    private class StringRemapper
    implements CodeReader.Visitor {
        private final DexFile file;

        public StringRemapper(DexFile dex) {
            this.file = dex;
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            int newIndex = ImportedCodeItem.this.cstIndexMap.getRemappedCstStringIndex(this.file, decodedInst.getFirstIndex());
            if (decodedInst.getOpcode() != 27 && newIndex > 65535) {
                throw new DexException("Cannot remap new index " + newIndex + " into a non-jumbo instruction!");
            }
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst.withIndex(newIndex);
        }
    }

    private class GenericVisitor
    implements CodeReader.Visitor {
        private GenericVisitor() {
        }

        @Override
        public void visit(DecodedInstruction[] all, DecodedInstruction decodedInst) {
            ((ImportedCodeItem)ImportedCodeItem.this).remappedInstructions[((ImportedCodeItem)ImportedCodeItem.this).remappingIndex++] = decodedInst;
        }
    }
}

