/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.code.form;

import com.android.jack.dx.dex.code.DalvInsn;
import com.android.jack.dx.dex.code.DualCstInsn;
import com.android.jack.dx.dex.code.InsnFormat;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.util.AnnotatedOutput;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Form45cc
extends InsnFormat {
    @Nonnull
    public static final InsnFormat THE_ONE = new Form45cc();
    @Nonnegative
    private static final int CODE_SIZE = 4;
    @Nonnegative
    protected static final int MAX_NUM_OPS = 5;

    private Form45cc() {
    }

    @Override
    @Nonnull
    public String insnArgString(@Nonnull DalvInsn insn) {
        RegisterSpecList regs = Form45cc.explicitize(insn.getRegisters());
        return Form45cc.regListString(regs) + ", " + Form45cc.cstString((DualCstInsn)insn);
    }

    @Override
    @Nonnull
    public String insnCommentString(@Nonnull DalvInsn insn, boolean noteIndices) {
        if (noteIndices) {
            return Form45cc.cstComment((DualCstInsn)insn);
        }
        return "";
    }

    @Override
    @Nonnegative
    public int codeSize() {
        return 4;
    }

    @Override
    public boolean isCompatible(@Nonnull DalvInsn insn) {
        if (!(insn instanceof DualCstInsn)) {
            return false;
        }
        DualCstInsn dualCstInsn = (DualCstInsn)insn;
        if (!Form45cc.unsignedFitsInShort(dualCstInsn.getFirstIndex())) {
            return false;
        }
        if (!(dualCstInsn.getFirstConstant() instanceof CstMethodRef)) {
            return false;
        }
        if (!Form45cc.unsignedFitsInShort(dualCstInsn.getSecondIndex())) {
            return false;
        }
        if (!(dualCstInsn.getSecondConstant() instanceof CstPrototypeRef)) {
            return false;
        }
        RegisterSpecList regs = dualCstInsn.getRegisters();
        return Form45cc.wordCount(regs) >= 0;
    }

    @Override
    @Nonnull
    public BitSet compatibleRegs(@Nonnull DalvInsn insn) {
        RegisterSpecList regs = insn.getRegisters();
        int sz = regs.size();
        BitSet bits = new BitSet(sz);
        for (int i = 0; i < sz; ++i) {
            RegisterSpec reg = regs.get(i);
            bits.set(i, Form45cc.unsignedFitsInNibble(reg.getReg() + reg.getCategory() - 1));
        }
        return bits;
    }

    @Override
    public void writeTo(@Nonnull AnnotatedOutput out, @Nonnull DalvInsn insn) {
        RegisterSpecList regs = Form45cc.explicitize(insn.getRegisters());
        int sz = regs.size();
        int r0 = sz > 0 ? regs.get(0).getReg() : 0;
        int r1 = sz > 1 ? regs.get(1).getReg() : 0;
        int r2 = sz > 2 ? regs.get(2).getReg() : 0;
        int r3 = sz > 3 ? regs.get(3).getReg() : 0;
        int r4 = sz > 4 ? regs.get(4).getReg() : 0;
        DualCstInsn dualCstInsn = (DualCstInsn)insn;
        Form45cc.write(out, Form45cc.opcodeUnit(insn, Form45cc.makeByte(r4, sz)), (short)dualCstInsn.getFirstIndex(), Form45cc.codeUnit(r0, r1, r2, r3), (short)dualCstInsn.getSecondIndex());
    }

    private static int wordCount(@Nonnull RegisterSpecList regs) {
        int sz = regs.size();
        if (sz > 5) {
            return -1;
        }
        int result = 0;
        for (int i = 0; i < sz; ++i) {
            RegisterSpec one = regs.get(i);
            result += one.getCategory();
            if (Form45cc.unsignedFitsInNibble(one.getReg() + one.getCategory() - 1)) continue;
            return -1;
        }
        return result <= 5 ? result : -1;
    }

    @Nonnull
    private static RegisterSpecList explicitize(@Nonnull RegisterSpecList orig) {
        int sz;
        int wordCount = Form45cc.wordCount(orig);
        if (wordCount == (sz = orig.size())) {
            return orig;
        }
        RegisterSpecList result = new RegisterSpecList(wordCount);
        int wordAt = 0;
        for (int i = 0; i < sz; ++i) {
            RegisterSpec one = orig.get(i);
            result.set(wordAt, one);
            if (one.getCategory() == 2) {
                result.set(wordAt + 1, RegisterSpec.make(one.getReg() + 1, Type.VOID));
                wordAt += 2;
                continue;
            }
            ++wordAt;
        }
        result.setImmutable();
        return result;
    }
}

