/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.digest;

import com.android.jack.Jack;
import com.android.jack.digest.OriginDigestElement;
import com.android.jack.digest.OriginDigestMarker;
import com.android.jack.digest.SourceDigestAdder;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.security.MessageDigest;
import java.util.EnumSet;
import javax.annotation.Nonnull;

@Description(value="Add digest on the origin of the type")
@Transform(add={OriginDigestMarker.class})
@Filter(value={SourceTypeFilter.class})
public class OriginDigestAdder
extends SourceDigestAdder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Nonnull
    private final String emitter = Jack.getEmitterId();
    private final int major = Jack.getVersion().getReleaseCode();
    private final int minor = Jack.getVersion().getSubReleaseCode();
    @Nonnull
    private final EnumSet<OriginDigestElement> descriptor = EnumSet.of(OriginDigestElement.SOURCE, new OriginDigestElement[]{OriginDigestElement.LOCAL_NAME, OriginDigestElement.PRIVATE_NAME, OriginDigestElement.PACKAGE_NAME, OriginDigestElement.PROTECTED_NAME, OriginDigestElement.PUBLIC_NAME});

    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        MessageDigest digest = this.computeSourceDigest(type);
        OriginDigestMarker marker = new OriginDigestMarker(this.descriptor, digest.getAlgorithm(), digest.digest(), this.emitter, this.major, this.minor);
        type.addMarker(marker);
    }
}

