/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.cfg;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.cfg.CatchBasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ExitBlock;
import com.android.jack.cfg.NormalBasicBlock;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JCatchBlock;
import com.android.jack.ir.ast.JStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

class ForwardBranchResolver {
    @Nonnull
    private final ExitBlock exitBlock;
    @Nonnull
    private final ArrayList<BlockToResolve> blocksToResolve = new ArrayList();

    public ForwardBranchResolver(@Nonnull ExitBlock exitBlock) {
        this.exitBlock = exitBlock;
    }

    void addNormalBasicBlock(@Nonnull NormalBasicBlock block, @CheckForNull JStatement targetStatement) {
        assert (block != null);
        this.blocksToResolve.add(new NormalBasicBlockToResolve(block, targetStatement));
    }

    void addConditionalBasicBlock(@Nonnull ConditionalBasicBlock block, @Nonnull JStatement thenStatement, @CheckForNull JStatement elseStatement) {
        assert (block != null);
        assert (thenStatement != null);
        this.blocksToResolve.add(new ConditionalBasicBlockToResolve(block, thenStatement, elseStatement));
    }

    void addSwitchBasicBlock(@Nonnull SwitchBasicBlock block, @Nonnull List<JCaseStatement> cases, @CheckForNull JStatement defaultCase) {
        assert (block != null);
        assert (cases != null);
        this.blocksToResolve.add(new SwitchBasicBlockToResolve(block, cases, defaultCase));
    }

    void addPeiBasicBlock(@Nonnull PeiBasicBlock block, @CheckForNull JStatement targetStatement, @Nonnull List<JCatchBlock> catchBlocks) {
        assert (block != null);
        assert (catchBlocks != null);
        this.blocksToResolve.add(new PeiBasicBlockToResolve(block, targetStatement, catchBlocks));
    }

    void resolve() {
        int len = this.blocksToResolve.size();
        for (int i = 0; i < len; ++i) {
            this.blocksToResolve.get(i).resolve();
        }
    }

    @Nonnull
    private static BasicBlock getTargetBlock(@Nonnull JStatement statement) {
        assert (statement != null);
        BasicBlockMarker bbm = statement.getMarker(BasicBlockMarker.class);
        assert (bbm != null);
        BasicBlock targetBb = bbm.getBasicBlock();
        assert (targetBb != null);
        return targetBb;
    }

    private static class PeiBasicBlockToResolve
    implements BlockToResolve {
        @Nonnull
        private final PeiBasicBlock block;
        @CheckForNull
        private final JStatement statement;
        @Nonnull
        private final List<JCatchBlock> catchBlocks;

        public PeiBasicBlockToResolve(@Nonnull PeiBasicBlock block, @CheckForNull JStatement statement, @Nonnull List<JCatchBlock> catchBlocks) {
            assert (block != null);
            assert (catchBlocks != null);
            this.block = block;
            this.statement = statement;
            this.catchBlocks = catchBlocks;
        }

        @Override
        public void resolve() {
            if (this.statement != null) {
                this.block.setTarget(ForwardBranchResolver.getTargetBlock(this.statement));
            }
            ListIterator<JCatchBlock> catchBlocksIter = this.catchBlocks.listIterator(this.catchBlocks.size());
            while (catchBlocksIter.hasPrevious()) {
                this.block.addExceptionBlock((CatchBasicBlock)ForwardBranchResolver.getTargetBlock(catchBlocksIter.previous()));
            }
        }
    }

    private class SwitchBasicBlockToResolve
    implements BlockToResolve {
        @Nonnull
        private final SwitchBasicBlock block;
        @Nonnull
        private final List<JCaseStatement> cases;
        @CheckForNull
        private final JStatement defaultCase;

        public SwitchBasicBlockToResolve(@Nonnull SwitchBasicBlock block, @CheckForNull List<JCaseStatement> cases, JStatement defaultCase) {
            assert (block != null);
            assert (cases != null);
            this.block = block;
            this.cases = cases;
            this.defaultCase = defaultCase;
        }

        @Override
        public void resolve() {
            for (JCaseStatement caseStatement : this.cases) {
                this.block.addCaseBlock(ForwardBranchResolver.getTargetBlock(caseStatement));
            }
            if (this.defaultCase == null) {
                this.block.setDefault(ForwardBranchResolver.this.exitBlock);
            } else {
                this.block.setDefault(ForwardBranchResolver.getTargetBlock(this.defaultCase));
            }
        }
    }

    private class ConditionalBasicBlockToResolve
    implements BlockToResolve {
        @Nonnull
        private final ConditionalBasicBlock block;
        @Nonnull
        private final JStatement ifStatement;
        @CheckForNull
        private final JStatement elseStatement;

        public ConditionalBasicBlockToResolve(@Nonnull ConditionalBasicBlock block, @CheckForNull JStatement ifStatement, JStatement elseStatement) {
            assert (block != null);
            assert (ifStatement != null);
            this.block = block;
            this.ifStatement = ifStatement;
            this.elseStatement = elseStatement;
        }

        @Override
        public void resolve() {
            this.block.setThenBlock(ForwardBranchResolver.getTargetBlock(this.ifStatement));
            if (this.elseStatement == null) {
                this.block.setElseBlock(ForwardBranchResolver.this.exitBlock);
            } else {
                this.block.setElseBlock(ForwardBranchResolver.getTargetBlock(this.elseStatement));
            }
        }
    }

    private class NormalBasicBlockToResolve
    implements BlockToResolve {
        @Nonnull
        private final NormalBasicBlock block;
        @CheckForNull
        private final JStatement statement;

        public NormalBasicBlockToResolve(@CheckForNull NormalBasicBlock block, JStatement statement) {
            assert (block != null);
            this.block = block;
            this.statement = statement;
        }

        @Override
        public void resolve() {
            if (this.statement == null) {
                this.block.setTarget(ForwardBranchResolver.this.exitBlock);
            } else {
                this.block.setTarget(ForwardBranchResolver.getTargetBlock(this.statement));
            }
        }
    }

    private static interface BlockToResolve {
        public void resolve();
    }
}

