/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.rop;

import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstNat;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.rop.type.TypeList;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JNullType;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.InternalFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import java.util.List;
import javax.annotation.Nonnull;

public class RopHelper {
    @Nonnull
    private static TypeAndMethodFormatter formatter = new RopFormatter();

    @Nonnull
    public static CstMethodRef createMethodRef(@Nonnull JMethod method) {
        return RopHelper.createMethodRef(method.getEnclosingType(), method);
    }

    @Nonnull
    public static CstMethodRef createMethodRef(@Nonnull JReferenceType type, @Nonnull JMethod method) {
        CstType definingClass = RopHelper.getCstType(type);
        CstNat nat = RopHelper.createSignature(method);
        CstMethodRef methodRef = new CstMethodRef(definingClass, nat);
        return methodRef;
    }

    @Nonnull
    public static String getPolymorphicCallSiteSymbolicDescriptor(@Nonnull JPolymorphicMethodCall methodCall) {
        BinarySignatureFormatter formatter = BinarySignatureFormatter.getFormatter();
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (JType argType : methodCall.getCallSiteParameterTypes()) {
            sb.append(formatter.getName(argType));
        }
        sb.append(')');
        sb.append(formatter.getName(methodCall.getType()));
        return sb.toString();
    }

    @Nonnull
    public static CstMethodRef createMethodRef(@Nonnull JMethodCall methodCall) {
        CstType definingClass = RopHelper.getCstType(methodCall.getReceiverType());
        String signatureWithoutName = RopHelper.getMethodSignatureWithoutName(methodCall);
        CstNat nat = new CstNat(new CstString(methodCall.getMethodName()), new CstString(signatureWithoutName));
        CstMethodRef methodRef = new CstMethodRef(definingClass, nat);
        return methodRef;
    }

    @Nonnull
    public static CstFieldRef createFieldRef(@Nonnull JField field, @Nonnull JClassOrInterface receiverType) {
        return RopHelper.createFieldRef(field.getId(), receiverType);
    }

    @Nonnull
    public static CstFieldRef createFieldRef(@Nonnull JFieldId field, @Nonnull JClassOrInterface receiverType) {
        CstType definingClass = RopHelper.getCstType(receiverType);
        CstNat nat = RopHelper.createSignature(field);
        CstFieldRef fieldRef = new CstFieldRef(definingClass, nat);
        return fieldRef;
    }

    @Nonnull
    public static CstString createString(@Nonnull JAbstractStringLiteral string) {
        CstString res = new CstString(string.getValue());
        return res;
    }

    @Nonnull
    public static CstString createString(@Nonnull String string) {
        CstString res = new CstString(string);
        return res;
    }

    @Nonnull
    public static String getMethodSignatureWithoutName(@Nonnull JPolymorphicMethodCall call) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (JType p : call.getMethodId().getParamTypes()) {
            sb.append(formatter.getName(p));
        }
        sb.append(')');
        sb.append(formatter.getName(call.getReturnTypeOfPolymorphicMethod()));
        return sb.toString();
    }

    @Nonnull
    public static String getMethodSignatureWithoutName(@Nonnull JMethodCall call) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (JType p : call.getMethodId().getParamTypes()) {
            sb.append(formatter.getName(p));
        }
        sb.append(')');
        sb.append(formatter.getName(call.getType()));
        return sb.toString();
    }

    @Nonnull
    public static SourcePosition getSourcePosition(@Nonnull JNode stmt) {
        if (stmt.getSourceInfo() == SourceInfo.UNKNOWN) {
            return SourcePosition.NO_INFO;
        }
        int startLine = stmt.getSourceInfo().getStartLine();
        return new SourcePosition(new CstString(stmt.getSourceInfo().getFileName()), -1, startLine == 0 ? -1 : startLine);
    }

    @Nonnull
    public static Type convertTypeToDx(@Nonnull JType type) {
        if (JNullType.isNullType(type)) {
            return Type.KNOWN_NULL;
        }
        if (type instanceof JPrimitiveType) {
            JPrimitiveType jPrimitiveType = (JPrimitiveType)type;
            JPrimitiveType.JPrimitiveTypeEnum primitiveType = jPrimitiveType.getPrimitiveTypeEnum();
            switch (primitiveType) {
                case BOOLEAN: {
                    return Type.BOOLEAN;
                }
                case BYTE: {
                    return Type.BYTE;
                }
                case CHAR: {
                    return Type.CHAR;
                }
                case DOUBLE: {
                    return Type.DOUBLE;
                }
                case FLOAT: {
                    return Type.FLOAT;
                }
                case INT: {
                    return Type.INT;
                }
                case LONG: {
                    return Type.LONG;
                }
                case SHORT: {
                    return Type.SHORT;
                }
                case VOID: {
                    return Type.VOID;
                }
            }
            throw new AssertionError((Object)(jPrimitiveType.toSource() + " not supported."));
        }
        return Type.intern(formatter.getName(type));
    }

    @Nonnull
    private static CstNat createSignature(@Nonnull JMethod method) {
        CstString name = new CstString(method.getName());
        CstString descriptor = new CstString(formatter.getName(method));
        CstNat signature = new CstNat(name, descriptor);
        return signature;
    }

    @Nonnull
    public static CstNat createSignature(@Nonnull JField field) {
        return RopHelper.createSignature(field.getId());
    }

    @Nonnull
    public static CstNat createSignature(@Nonnull JFieldId field) {
        String fieldName = field.getName();
        String fieldSignature = formatter.getName(field.getType());
        CstString name = new CstString(fieldName);
        CstString descriptor = new CstString(fieldSignature);
        CstNat signature = new CstNat(name, descriptor);
        return signature;
    }

    public static boolean areTypeCompatible(@Nonnull Type type1, @Nonnull Type type2) {
        return type1.getBasicFrameType() == type2.getBasicFrameType();
    }

    @Nonnull
    public static TypeList createTypeList(@Nonnull List<? extends JType> types) {
        StdTypeList typesList = StdTypeList.EMPTY;
        int elementsCount = types.size();
        if (elementsCount > 0) {
            typesList = new StdTypeList(elementsCount);
            for (int i = 0; i < elementsCount; ++i) {
                JType type = types.get(i);
                typesList.set(i, RopHelper.convertTypeToDx(type));
            }
        }
        return typesList;
    }

    @Nonnull
    public static CstType getCstType(@Nonnull JType type) {
        Type ropType = RopHelper.convertTypeToDx(type);
        CstType cstType = CstType.intern(ropType);
        return cstType;
    }

    private static class RopFormatter
    extends InternalFormatter {
        private RopFormatter() {
        }

        @Override
        @Nonnull
        public String getName(@Nonnull JMethod method) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (JParameter p : method.getParams()) {
                sb.append(this.getName(p.getType()));
            }
            sb.append(')');
            sb.append(this.getName(method.getType()));
            return sb.toString();
        }
    }
}

