/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.multidex.legacy;

import com.android.jack.backend.dex.MainDexMarker;
import com.android.jack.backend.dex.MultiDexLegacy;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.sched.item.Description;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Mark classes annotated by runtime annotation as main dex")
@Transform(add={MainDexMarker.class})
@Support(value={MultiDexLegacy.class})
public class AnnotatedFinder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public void run(@Nonnull JDefinedClassOrInterface type) {
        if (this.hasRuntimeAnnotation(type)) {
            type.addMarker(MainDexMarker.INSTANCE);
        }
    }

    private boolean hasRuntimeAnnotation(@Nonnull JDefinedClassOrInterface type) {
        if (this.isAnnotatedByRuntimeAnnotation(type)) {
            return true;
        }
        for (JField field : type.getFields()) {
            if (!this.isAnnotatedByRuntimeAnnotation(field)) continue;
            return true;
        }
        for (JMethod method : type.getMethods()) {
            if (this.isAnnotatedByRuntimeAnnotation(method)) {
                return true;
            }
            for (JParameter param : method.getParams()) {
                if (!this.isAnnotatedByRuntimeAnnotation(param)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnnotatedByRuntimeAnnotation(@Nonnull Annotable annotable) {
        for (JAnnotationType annotation : annotable.getAnnotationTypes()) {
            if (!(annotation instanceof JDefinedAnnotationType) || ((JDefinedAnnotationType)annotation).getRetentionPolicy() != JRetentionPolicy.RUNTIME) continue;
            return true;
        }
        return false;
    }
}

