/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.analysis.tracer.AbstractTracerBrush;
import com.android.jack.analysis.tracer.BaseTracerMarker;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Marks classes and members that may be used by legacy multidex installation")
@Transform(add={TracerMarker.class})
@Constraint(need={MultiDexInstallerMarker.class})
public class MultiDexLegacyTracerBrush
extends AbstractTracerBrush<TracerMarker> {
    public MultiDexLegacyTracerBrush() {
        super(false, TracerMarker.class, MultiDexInstallerMarker.class);
    }

    @Override
    @Nonnull
    protected TracerMarker createMarkerFor(@Nonnull JNode node) {
        return new TracerMarker();
    }

    @ValidOn(value={JDefinedClassOrInterface.class, JMethod.class, JField.class})
    @Description(value="Indicates that this node may be an entry point used by multidex legacy support installation")
    public static class MultiDexInstallerMarker
    implements Marker {
        @Nonnull
        public static final MultiDexInstallerMarker INSTANCE = new MultiDexInstallerMarker();

        private MultiDexInstallerMarker() {
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            return this;
        }
    }

    @ValidOn(value={JDefinedClassOrInterface.class, JMethod.class, JField.class})
    @Description(value="Indicates that this node was identified during the main dex legacy tracing")
    public static class TracerMarker
    extends BaseTracerMarker {
    }
}

