/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JAbstractStringLiteral;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JExpressionStatement;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JReferenceType;
import com.android.jack.ir.ast.JType;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Removes JFieldInitializer")
@Synchronized
@Constraint(need={JFieldInitializer.class})
@Transform(add={JAsgOperation.NonReusedAsg.class, JExpressionStatement.class}, remove={JFieldInitializer.class, ThreeAddressCodeForm.class})
@Filter(value={SourceTypeFilter.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class FieldInitializerRemover
implements RunnableSchedulable<JField> {
    @Nonnull
    public static final BooleanPropertyId CLASS_AS_INITIALVALUE = BooleanPropertyId.create("jack.legacy.dx.initialvalue.class", "Emit class literal as initial value of field").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    @Nonnull
    public static final BooleanPropertyId STRING_AS_INITIALVALUE_OF_OBJECT = BooleanPropertyId.create("jack.legacy.runtime.initialvalue.string", "Emit string literal as initial value of field").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class);
    private final boolean allowClassInInitialValue = ThreadConfig.get(CLASS_AS_INITIALVALUE);
    private final boolean allowStringAsObjectInit = ThreadConfig.get(STRING_AS_INITIALVALUE_OF_OBJECT);
    @Nonnull
    private final JClass stringType = Jack.getSession().getPhantomLookup().getClass(CommonTypes.JAVA_LANG_STRING);

    @Override
    public synchronized void run(@Nonnull JField field) {
        JFieldInitializer declaration = field.getFieldInitializer();
        if (declaration != null) {
            JExpression initialValue = declaration.getInitializer();
            TransformationRequest tr = new TransformationRequest(declaration.getParent());
            if (field.isStatic() && field.isFinal() && initialValue instanceof JLiteral && (this.allowStringAsObjectInit || field.getType().isSameType(this.stringType) || !(initialValue instanceof JAbstractStringLiteral)) && (this.allowClassInInitialValue || !(initialValue instanceof JClassLiteral)) && !this.hasBoxing(field.getType(), (JLiteral)initialValue)) {
                field.setInitialValue((JLiteral)initialValue);
                field.setFieldInitializer(null);
                tr.append(new Remove(declaration));
            } else {
                JAsgOperation assign = new JAsgOperation(declaration.getSourceInfo(), declaration.getFieldRef(), initialValue);
                tr.append(new Replace(declaration, assign.makeStatement()));
            }
            tr.commit();
        }
    }

    private boolean hasBoxing(@Nonnull JType fieldType, @Nonnull JLiteral initialValue) {
        JType valueType = initialValue.getType();
        if (valueType instanceof JPrimitiveType && fieldType instanceof JReferenceType) {
            assert (this.isCompatible(fieldType, initialValue, valueType));
            return true;
        }
        return false;
    }

    private boolean isCompatible(@Nonnull JType fieldType, @Nonnull JLiteral initialValue, @Nonnull JType valueType) {
        boolean requiredBoxing = ((JPrimitiveType)valueType).isEquivalent(fieldType);
        if (!requiredBoxing && initialValue instanceof JIntLiteral) {
            int value = ((JIntLiteral)initialValue).getValue();
            requiredBoxing |= JPrimitiveType.JPrimitiveTypeEnum.BYTE.getType().isEquivalent(fieldType) && value >= -128 && value <= 127;
            requiredBoxing |= JPrimitiveType.JPrimitiveTypeEnum.SHORT.getType().isEquivalent(fieldType) && value >= Short.MIN_VALUE && value <= Short.MAX_VALUE;
            requiredBoxing |= JPrimitiveType.JPrimitiveTypeEnum.CHAR.getType().isEquivalent(fieldType) && value >= 0 && value <= 65535;
        }
        return requiredBoxing;
    }
}

